/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.adt.subgraph.SubEdge;
import uniol.apt.adt.subgraph.SubGraph;
import uniol.apt.adt.subgraph.SubNode;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.analysis.cycles.CycleCallback;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class CycleSearch {
    public <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> void searchCycles(G graph, CycleCallback<G, E, N> cycleCb) {
        ArrayDeque componentSubgraphs = new ArrayDeque();
        for (Set component : Connectivity.getStronglyConnectedComponents(graph)) {
            componentSubgraphs.add(SubGraph.getSubGraphByNodes(graph, component));
        }
        while (!componentSubgraphs.isEmpty()) {
            SubGraph subgraph = (SubGraph)componentSubgraphs.removeLast();
            Set nodes = subgraph.getNodes();
            Iterator it = nodes.iterator();
            SubNode start = it.next();
            new DoDfs(start, subgraph, cycleCb);
            it.remove();
            subgraph = subgraph.getFlatSubGraphByNodes(nodes);
            for (Set set : Connectivity.getStronglyConnectedComponents(subgraph)) {
                componentSubgraphs.add(subgraph.getFlatSubGraphByNodes(set));
            }
        }
    }

    private static class DoDfs<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> {
        private final SubNode<G, E, N> start;
        private final CycleCallback<G, E, N> cycleCb;
        private final Deque<SubNode<G, E, N>> sStack;
        private final Deque<SubEdge<G, E, N>> lStack;
        private final Set<SubNode<G, E, N>> blocked;
        private final Map<SubNode<G, E, N>, Set<SubNode<G, E, N>>> b;

        public DoDfs(SubNode<G, E, N> start, SubGraph<G, E, N> graph, CycleCallback<G, E, N> cycleCb) {
            this.start = start;
            this.cycleCb = cycleCb;
            this.sStack = new ArrayDeque<SubNode<G, E, N>>();
            this.lStack = new ArrayDeque<SubEdge<G, E, N>>();
            this.blocked = new HashSet<SubNode<G, E, N>>();
            this.b = new HashMap<SubNode<G, E, N>, Set<SubNode<G, E, N>>>();
            for (SubNode<G, E, N> node : graph.getNodes()) {
                this.b.put(node, new HashSet());
            }
            this.doDfs(start);
            assert (this.sStack.isEmpty());
            assert (this.lStack.isEmpty());
        }

        private boolean doDfs(SubNode<G, E, N> cur) {
            boolean foundCycle = false;
            this.blocked.add(cur);
            this.sStack.addLast(cur);
            for (SubEdge<G, E, N> subEdge : cur.getPostsetEdges()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                this.lStack.addLast(subEdge);
                INode next = subEdge.getTarget();
                if (((SubNode)next).equals(this.start)) {
                    ArrayList<N> sCycle = new ArrayList<N>();
                    for (SubNode<G, E, N> node : this.sStack) {
                        sCycle.add(node.getOriginalNode());
                    }
                    ArrayList<E> lCycle = new ArrayList<E>();
                    for (SubEdge<G, E, N> edge : this.lStack) {
                        lCycle.add(edge.getOriginalEdge());
                    }
                    this.cycleCb.cycleFound(sCycle, lCycle);
                    foundCycle = true;
                } else if (!this.blocked.contains(next)) {
                    foundCycle |= this.doDfs((SubNode<G, E, N>)next);
                }
                this.lStack.removeLast();
            }
            this.sStack.removeLast();
            if (foundCycle) {
                this.unblock(cur);
            } else {
                for (SubNode subNode : cur.getPostsetNodes()) {
                    this.b.get(cur).add(subNode);
                }
            }
            return foundCycle;
        }

        private void unblock(SubNode<G, E, N> node) {
            this.blocked.remove(node);
            for (SubNode<G, E, N> prev : this.b.get(node)) {
                if (!this.blocked.contains(prev)) continue;
                this.unblock(prev);
            }
            this.b.put(node, new HashSet());
        }
    }
}

