/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles;

import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.CycleCounterExample;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CheckAllCyclePropertiesModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "check_all_cycle_prop";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("same_parikh_vectors", Boolean.class, "success");
        outputSpec.addReturnValue("counter_example_same", CycleCounterExample.class, new String[0]);
        outputSpec.addReturnValue("same_or_mutually_disjoint_pv", Boolean.class, "success");
        outputSpec.addReturnValue("counter_example_disjoint", CycleCounterExample.class, new String[0]);
        outputSpec.addReturnValue("parikh_vectors", Set.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        TransitionSystem ts = CoverabilityGraph.get(pn).toReachabilityLTS();
        ComputeSmallestCycles small = new ComputeSmallestCycles();
        Set<? extends CyclePV> parikhs = small.computePVsOfSmallestCycles(ts);
        output.setReturnValue("parikh_vectors", Set.class, parikhs);
        boolean b = small.checkSamePVs(parikhs);
        if (!b) {
            output.setReturnValue("counter_example_same", CycleCounterExample.class, small.getCounterExample());
        }
        output.setReturnValue("same_parikh_vectors", Boolean.class, b);
        boolean bo = small.checkSameOrMutallyDisjointPVs(parikhs);
        if (!bo) {
            output.setReturnValue("counter_example_disjoint", CycleCounterExample.class, small.getCounterExample());
        }
        output.setReturnValue("same_or_mutually_disjoint_pv", Boolean.class, bo);
    }

    @Override
    public String getShortDescription() {
        return "Check all cycle properties of a Petri net";
    }

    @Override
    public String getLongDescription() {
        return "Check if all smallest cycles have same Parikh vectors, if all smallest cycles have same or mutually disjoint Parikh vectors and it computes Parikh vectors of smallest cycles";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

