/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.coverability;

import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CoverabilityModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Compute a Petri net's coverability graph";
    }

    @Override
    public String getName() {
        return "coverability_graph";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("lts", TransitionSystem.class, "file", "raw");
        outputSpec.addReturnValue("reachability_graph", Boolean.class, "success");
    }

    protected CoverabilityGraph getGraph(PetriNet pn) {
        return CoverabilityGraph.get(pn);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        TransitionSystem result = this.getGraph(pn).toCoverabilityLTS();
        boolean isReachability = true;
        for (State node : result.getNodes()) {
            CoverabilityGraphNode coverNode = (CoverabilityGraphNode)node.getExtension(CoverabilityGraphNode.class.getName());
            if (coverNode.getMarking().hasOmega()) {
                isReachability = false;
            }
            node.putExtension("marking", coverNode.getMarking().toString(), ExtensionProperty.WRITE_TO_FILE);
        }
        output.setReturnValue("lts", TransitionSystem.class, result);
        output.setReturnValue("reachability_graph", Boolean.class, isReachability);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

