/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.coverability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;

public class CoverabilityGraphNode {
    private final CoverabilityGraph graph;
    private final Marking marking;
    private final Transition reachingTransition;
    private final CoverabilityGraphNode parent;
    private final CoverabilityGraphNode covered;
    private Set<CoverabilityGraphEdge> postsetEdges;

    CoverabilityGraphNode(CoverabilityGraph graph, Transition transition, Marking marking, CoverabilityGraphNode parent, CoverabilityGraphNode covered) {
        this.graph = graph;
        this.marking = marking;
        this.parent = parent;
        this.covered = covered;
        this.reachingTransition = transition;
    }

    CoverabilityGraphNode getParent() {
        return this.parent;
    }

    public CoverabilityGraphNode getCoveredNode() {
        return this.covered;
    }

    public Marking getMarking() {
        return new Marking(this.marking);
    }

    public List<Transition> getFiringSequence() {
        ArrayList<Transition> result = new ArrayList<Transition>();
        CoverabilityGraphNode node = this;
        while (node.reachingTransition != null) {
            result.add(node.reachingTransition);
            node = node.parent;
        }
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    public List<Transition> getFiringSequenceFromCoveredNode() {
        if (this.covered == null) {
            return null;
        }
        int coveredSequenceLength = this.covered.getFiringSequence().size();
        List<Transition> firingSequence = this.getFiringSequence();
        return firingSequence.subList(coveredSequenceLength, firingSequence.size());
    }

    public Set<CoverabilityGraphNode> getPostset() {
        HashSet<CoverabilityGraphNode> postset = new HashSet<CoverabilityGraphNode>();
        for (CoverabilityGraphEdge edge : this.getPostsetEdges()) {
            postset.add(edge.getTarget());
        }
        return Collections.unmodifiableSet(postset);
    }

    public Set<CoverabilityGraphEdge> getPostsetEdges() {
        if (this.postsetEdges == null) {
            this.postsetEdges = Collections.unmodifiableSet(this.graph.getPostsetEdges(this));
        }
        return this.postsetEdges;
    }
}

