/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.coverability;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;

class CoverabilityGraphEdgesIterator
implements Iterator<CoverabilityGraphEdge> {
    private final Iterator<CoverabilityGraphNode> nodeIter;
    private Iterator<CoverabilityGraphEdge> edgeIter;

    CoverabilityGraphEdgesIterator(CoverabilityGraph cover) {
        this.nodeIter = cover.getNodes().iterator();
        if (this.nodeIter.hasNext()) {
            this.edgeIter = this.nodeIter.next().getPostsetEdges().iterator();
        }
    }

    private boolean updateEdgeIter() {
        while (!this.edgeIter.hasNext()) {
            if (this.nodeIter.hasNext()) {
                this.edgeIter = this.nodeIter.next().getPostsetEdges().iterator();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.updateEdgeIter();
    }

    @Override
    public CoverabilityGraphEdge next() {
        if (this.updateEdgeIter()) {
            return this.edgeIter.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

