/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.coverability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.StructuralExtensionRemover;
import uniol.apt.adt.exception.ArcExistsException;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;
import uniol.apt.analysis.coverability.CoverabilityGraphEdgesIterator;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class CoverabilityGraph {
    private final PetriNet pn;
    private final Map<Marking, CoverabilityGraphNode> states = new HashMap<Marking, CoverabilityGraphNode>();
    private int indexOfFirstUnvisited = 0;
    private final List<CoverabilityGraphNode> nodes = new ArrayList<CoverabilityGraphNode>();
    private final boolean reachabilityGraph;

    public static CoverabilityGraph get(PetriNet pn) {
        return CoverabilityGraph.get(pn, false);
    }

    public static CoverabilityGraph getReachabilityGraph(PetriNet pn) {
        return CoverabilityGraph.get(pn, true);
    }

    private static CoverabilityGraph get(PetriNet pn, boolean reachabilityGraph) {
        String key = CoverabilityGraph.class.getName();
        if (reachabilityGraph) {
            key = key + "-reachability";
        }
        Object extension = null;
        try {
            extension = pn.getExtension(key);
        }
        catch (StructureException structureException) {
            // empty catch block
        }
        if (extension != null && extension instanceof CoverabilityGraph) {
            return (CoverabilityGraph)extension;
        }
        CoverabilityGraph result = new CoverabilityGraph(pn, reachabilityGraph);
        pn.putExtension(key, result, ExtensionProperty.NOCOPY);
        pn.addListener(new StructuralExtensionRemover(key));
        return result;
    }

    private CoverabilityGraph(PetriNet pn, boolean reachabilityGraph) {
        this.pn = pn;
        this.reachabilityGraph = reachabilityGraph;
        this.getNode(null, pn.getInitialMarking(), null, null);
    }

    public int calculateNodes() {
        do {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
        } while (this.visitNode());
        return this.nodes.size();
    }

    private boolean visitNode() {
        if (this.indexOfFirstUnvisited >= this.nodes.size()) {
            return false;
        }
        this.nodes.get(this.indexOfFirstUnvisited).getPostsetEdges();
        ++this.indexOfFirstUnvisited;
        return true;
    }

    Set<CoverabilityGraphEdge> getPostsetEdges(CoverabilityGraphNode node) {
        Marking marking = node.getMarking();
        HashSet<CoverabilityGraphEdge> result = new HashSet<CoverabilityGraphEdge>();
        for (Transition t : this.pn.getTransitions()) {
            if (!t.isFireable(marking)) continue;
            Marking newMarking = t.fire(marking);
            Pair<CoverabilityGraphNode, Marking> covered = this.checkCover(newMarking, node);
            CoverabilityGraphNode target = covered == null ? this.getNode(t, newMarking, node, null) : this.getNode(t, covered.getSecond(), node, covered.getFirst());
            result.add(new CoverabilityGraphEdge(t, node, target));
        }
        return result;
    }

    private Pair<CoverabilityGraphNode, Marking> checkCover(Marking cur, CoverabilityGraphNode parent) {
        if (this.reachabilityGraph) {
            return null;
        }
        assert (parent != null);
        while (parent != null) {
            Marking m = cur.cover(parent.getMarking());
            if (m != null) {
                return new Pair<CoverabilityGraphNode, Marking>(parent, m);
            }
            parent = parent.getParent();
        }
        return null;
    }

    private CoverabilityGraphNode getNode(Transition transition, Marking cur, CoverabilityGraphNode from, CoverabilityGraphNode covered) {
        CoverabilityGraphNode state = this.states.get(cur);
        if (state == null) {
            state = new CoverabilityGraphNode(this, transition, cur, from, covered);
            this.states.put(cur, state);
            this.nodes.add(state);
        }
        return state;
    }

    public CoverabilityGraphNode getInitialNode() {
        return this.nodes.get(0);
    }

    public Iterable<CoverabilityGraphNode> getNodes() {
        return new Iterable<CoverabilityGraphNode>(){

            @Override
            public Iterator<CoverabilityGraphNode> iterator() {
                return new Iterator<CoverabilityGraphNode>(){
                    private int position = 0;

                    @Override
                    public boolean hasNext() {
                        do {
                            if (this.position >= CoverabilityGraph.this.nodes.size()) continue;
                            return true;
                        } while (CoverabilityGraph.this.visitNode());
                        return false;
                    }

                    @Override
                    public CoverabilityGraphNode next() {
                        this.hasNext();
                        return (CoverabilityGraphNode)CoverabilityGraph.this.nodes.get(this.position++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<CoverabilityGraphEdge> getEdges() {
        final CoverabilityGraph graph = this;
        return new Iterable<CoverabilityGraphEdge>(){

            @Override
            public Iterator<CoverabilityGraphEdge> iterator() {
                return new CoverabilityGraphEdgesIterator(graph);
            }
        };
    }

    public TransitionSystem toReachabilityLTS() throws UnboundedException {
        return this.toLTS(true);
    }

    public TransitionSystem toCoverabilityLTS() {
        try {
            if (this.reachabilityGraph) {
                return this.toReachabilityLTS();
            }
            return this.toLTS(false);
        }
        catch (UnboundedException e) {
            throw new RuntimeException(e);
        }
    }

    private TransitionSystem toLTS(boolean onlyReachability) throws UnboundedException {
        String name = (onlyReachability ? "Reachability" : "Coverability") + " graph of " + this.pn.getName();
        HashMap<Marking, State> ltsStates = new HashMap<Marking, State>();
        TransitionSystem lts = new TransitionSystem(name);
        lts.putExtension(PetriNet.class.getName(), this.pn);
        for (CoverabilityGraphNode node : this.getNodes()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Marking mark = node.getMarking();
            assert (ltsStates.get(mark) == null);
            State n = lts.createState();
            ltsStates.put(mark, n);
            n.putExtension(Marking.class.getName(), mark);
            n.putExtension(CoverabilityGraphNode.class.getName(), node);
            if (!onlyReachability || !mark.hasOmega()) continue;
            throw new UnboundedException(this.pn);
        }
        for (CoverabilityGraphNode sourceNode : this.getNodes()) {
            State source = (State)ltsStates.get(sourceNode.getMarking());
            for (CoverabilityGraphEdge edge : sourceNode.getPostsetEdges()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                State target = (State)ltsStates.get(edge.getTarget().getMarking());
                Transition transition = edge.getTransition();
                try {
                    Arc e = lts.createArc(source.getId(), target.getId(), transition.getLabel());
                    e.putExtension(Transition.class.getName(), transition);
                    e.putExtension(CoverabilityGraphEdge.class.getName(), edge);
                }
                catch (ArcExistsException arcExistsException) {}
            }
        }
        Marking initialMarking = this.pn.getInitialMarking();
        State initialNode = (State)ltsStates.get(initialMarking);
        lts.setInitialState(initialNode);
        assert (initialNode != null);
        return lts;
    }
}

