/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.conpres;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.conpres.ConcurrencyPreserving;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ConcurrencyPreservingModule
extends AbstractModule
implements InterruptibleModule {
    private static final String SHORTDESCRIPTION = "Check if a Petri net is concurrency-preserving";
    private static final String LONGDESCRIPTION = "This module checks if a Petri net is concurrency-preserving.That is: for every transition t there are as many places in the preset as in the postset of t.";
    private static final String TITLE = "concurrency-preserving";
    private static final String NAME = "conpres";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue(NAME, Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("net", PetriNet.class);
        ConcurrencyPreserving c = new ConcurrencyPreserving(pn);
        output.setReturnValue(NAME, Boolean.class, c.check());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getShortDescription() {
        return SHORTDESCRIPTION;
    }

    @Override
    public String getLongDescription() {
        return LONGDESCRIPTION;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

