/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.connectivity;

import java.util.Iterator;
import java.util.Set;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WeakConnectivityModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net or LTS is weakly connected";
    }

    @Override
    public String getName() {
        return "weakly_connected";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", IGraph.class, "The graph that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("weakly_connected", Boolean.class, "success");
        outputSpec.addReturnValue("witness_node1", INode.class, new String[0]);
        outputSpec.addReturnValue("witness_node2", INode.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        IGraph graph = input.getParameter("graph", IGraph.class);
        Set<Set<INode<?, ?, ?>>> components = WeakConnectivityModule.run(graph);
        boolean connected = components.size() <= 1;
        output.setReturnValue("weakly_connected", Boolean.class, connected);
        if (!connected) {
            Iterator<Set<INode<?, ?, ?>>> it = components.iterator();
            output.setReturnValue("witness_node1", INode.class, it.next().iterator().next());
            output.setReturnValue("witness_node2", INode.class, it.next().iterator().next());
        }
    }

    private static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<? extends Set<? extends INode<?, ?, ?>>> run(IGraph<?, ?, ?> graph) {
        return Connectivity.getWeaklyConnectedComponents(graph);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

