/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.connectivity;

import java.util.Collection;
import java.util.Set;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.analysis.connectivity.Components;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WeakComponentsModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Find the weakly connected components of a Petri net or LTS";
    }

    @Override
    public String getName() {
        return "weak_components";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", IGraph.class, "The graph that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("weak_components", Components.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        IGraph graph = input.getParameter("graph", IGraph.class);
        Set<Set<INode<?, ?, ?>>> components = WeakComponentsModule.run(graph);
        output.setReturnValue("weak_components", Components.class, new Components((Collection<? extends Set<? extends INode<?, ?, ?>>>)components));
    }

    private static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<? extends Set<? extends INode<?, ?, ?>>> run(IGraph<?, ?, ?> graph) {
        return Connectivity.getWeaklyConnectedComponents(graph);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

