/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.connectivity;

import java.util.Collection;
import java.util.Set;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.analysis.connectivity.Component;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class IsolatedElementsModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Find isolated elements in a graph";
    }

    @Override
    public String getName() {
        return "isolated_elements";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", IGraph.class, "The graph that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("isolated_elements", Component.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        IGraph graph = input.getParameter("graph", IGraph.class);
        Set<INode<?, ?, ?>> collection = IsolatedElementsModule.run(graph);
        output.setReturnValue("isolated_elements", Component.class, new Component((Collection<? extends INode<?, ?, ?>>)collection));
    }

    private static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<? extends INode<?, ?, ?>> run(IGraph<?, ?, ?> graph) {
        return Connectivity.findIsolatedElements(graph);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

