/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.connectivity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Connectivity {
    private Connectivity() {
    }

    public static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<N> findIsolatedElements(G graph) {
        HashSet<INode> result = new HashSet<INode>();
        for (INode node : graph.getNodes()) {
            if (!node.getPresetNodes().isEmpty() || !node.getPostsetNodes().isEmpty()) continue;
            result.add(node);
        }
        return result;
    }

    public static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> boolean isWeaklyConnected(G graph) {
        return Connectivity.getWeaklyConnectedComponents(graph).size() <= 1;
    }

    public static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<? extends Set<N>> getWeaklyConnectedComponents(G graph) {
        HashSet<N> unhandled = new HashSet<N>();
        HashSet<Set<INode>> result = new HashSet<Set<INode>>();
        unhandled.addAll(graph.getNodes());
        while (!unhandled.isEmpty()) {
            Iterator it = unhandled.iterator();
            INode node = (INode)it.next();
            it.remove();
            Set<INode> component = Connectivity.getWeaklyConnectedComponent(node);
            unhandled.removeAll(component);
            result.add(component);
        }
        return result;
    }

    public static <N extends INode<?, ?, N>> Set<N> getWeaklyConnectedComponent(N node) {
        HashSet<INode> result = new HashSet<INode>();
        ArrayDeque<INode> unvisited = new ArrayDeque<INode>();
        unvisited.add((INode)node);
        result.add((INode)node);
        while (!unvisited.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            node = (INode)unvisited.removeLast();
            for (INode curNode : node.getPresetNodes()) {
                if (!result.add(curNode)) continue;
                unvisited.add(curNode);
            }
            for (INode curNode : node.getPostsetNodes()) {
                if (!result.add(curNode)) continue;
                unvisited.add(curNode);
            }
        }
        return result;
    }

    public static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> boolean isStronglyConnected(G graph) {
        return Connectivity.getStronglyConnectedComponents(graph).size() <= 1;
    }

    public static <G extends IGraph<G, ?, N>, N extends INode<G, ?, N>> Set<? extends Set<N>> getStronglyConnectedComponents(G graph) {
        HashSet<Set<N>> result = new HashSet<Set<N>>();
        HashMap dfsNumbers = new HashMap();
        HashMap minNumbers = new HashMap();
        int counter = 0;
        for (INode node : graph.getNodes()) {
            if (dfsNumbers.containsKey(node)) continue;
            counter = Connectivity.handleStronglyConnectedComponents(node, result, dfsNumbers, minNumbers, counter);
        }
        return result;
    }

    private static <N extends INode<?, ?, N>> int handleStronglyConnectedComponents(N node, Set<Set<N>> result, Map<N, Integer> dfsNumbers, Map<N, Integer> minNumbers, int counter) {
        ArrayDeque<N> callers = new ArrayDeque<N>();
        ArrayDeque stack = new ArrayDeque();
        HashSet stackAsSet = new HashSet();
        counter = Connectivity.visitNode(node, dfsNumbers, minNumbers, counter, stack, stackAsSet);
        do {
            INode next;
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            boolean done = true;
            for (INode current : node.getPostsetNodes()) {
                if (!dfsNumbers.containsKey(current)) {
                    callers.addLast((N)node);
                    node = current;
                    counter = Connectivity.visitNode(node, dfsNumbers, minNumbers, counter, stack, stackAsSet);
                    done = false;
                    break;
                }
                if (!stackAsSet.contains(current) || minNumbers.get(node) <= minNumbers.get(current)) continue;
                minNumbers.put(node, Math.min(minNumbers.get(node), dfsNumbers.get(current)));
            }
            if (!done) continue;
            if (dfsNumbers.get(node).equals(minNumbers.get(node))) {
                HashSet<INode> component = new HashSet<INode>();
                INode cur = null;
                while (cur != node) {
                    cur = (INode)stack.removeLast();
                    boolean removed = stackAsSet.remove(cur);
                    assert (removed);
                    component.add(cur);
                }
                result.add(component);
            }
            if ((next = (INode)callers.pollLast()) != null) {
                minNumbers.put(next, Math.min(minNumbers.get(next), minNumbers.get(node)));
            }
            node = next;
        } while (node != null);
        assert (callers.isEmpty());
        assert (stack.isEmpty());
        assert (stackAsSet.isEmpty());
        return counter;
    }

    private static <N extends INode<?, ?, ?>> int visitNode(N node, Map<N, Integer> dfsNumbers, Map<N, Integer> minNumbers, int counter, Deque<N> stack, Set<N> stackAsSet) {
        assert (!dfsNumbers.containsKey(node));
        assert (!minNumbers.containsKey(node));
        dfsNumbers.put(node, ++counter);
        minNumbers.put(node, counter);
        stack.add(node);
        boolean added = stackAsSet.add(node);
        assert (added);
        return counter;
    }
}

