/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cf;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.cf.ConflictFree;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ConflictFreeModule
extends AbstractModule
implements InterruptibleModule {
    private static final String SHORTDESCRIPTION = "Check if a plain Petri net is conflict-free";
    private static final String LONGDESCRIPTION = "This module tests if a plain Petri net is conflict-free. That is: \n\\forall s \\in S: \\mid s^\\bullet \\mid \\leq 1 \\vee s^\\bullet \\subset ^\\bullet s";
    private static final String TITLE = "conflict-free";
    private static final String NAME = "cf";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", "plain");
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue(NAME, Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("net", PetriNet.class);
        ConflictFree cf = new ConflictFree(pn);
        output.setReturnValue(NAME, Boolean.class, cf.check());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getShortDescription() {
        return SHORTDESCRIPTION;
    }

    @Override
    public String getLongDescription() {
        return LONGDESCRIPTION;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

