/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cf;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class ConflictFree {
    private final PetriNet pn;

    public ConflictFree(PetriNet pn) {
        this.pn = pn;
    }

    public boolean check() throws PreconditionFailedException {
        if (!new Plain().checkPlain(this.pn)) {
            throw new PreconditionFailedException("the net is not plain.");
        }
        for (Place place : this.pn.getPlaces()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (place.getPostset().size() <= 1 || place.getPreset().containsAll(place.getPostset())) continue;
            return false;
        }
        return true;
    }
}

