/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bounded;

import java.util.Collection;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.bounded.Bounded;
import uniol.apt.analysis.bounded.BoundedResult;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SafeModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net is safe";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net is safe if no marking is reachable were a place has more than one token.";
    }

    @Override
    public String getName() {
        return "safe";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("safe", Boolean.class, "success");
        outputSpec.addReturnValue("witness_place", Place.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence", FiringSequence.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        BoundedResult result = Bounded.checkBounded(pn);
        output.setReturnValue("safe", Boolean.class, result.isSafe());
        if (!result.isSafe()) {
            output.setReturnValue("witness_place", Place.class, result.unboundedPlace);
            output.setReturnValue("witness_firing_sequence", FiringSequence.class, new FiringSequence((Collection<Transition>)result.getSequenceExceeding(1)));
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

