/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bounded;

import java.util.Collection;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.bounded.Bounded;
import uniol.apt.analysis.bounded.BoundedResult;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class KBoundedModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Find the smallest k for which a Petri net is k-bounded";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net is bounded if there is an upper limit for the number of token on each place. It is k-bounded if this limit isn't bigger than k.";
    }

    @Override
    public String getName() {
        return "k_bounded";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("k", Long.class, new String[0]);
        outputSpec.addReturnValue("bounded", Boolean.class, "success");
        outputSpec.addReturnValue("witness_place", Place.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence", FiringSequence.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence_cycle", FiringSequence.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        BoundedResult result = Bounded.checkBounded(pn);
        output.setReturnValue("k", Long.class, result.k);
        output.setReturnValue("bounded", Boolean.class, result.isBounded());
        output.setReturnValue("witness_place", Place.class, result.unboundedPlace);
        output.setReturnValue("witness_firing_sequence", FiringSequence.class, new FiringSequence((Collection<Transition>)result.sequence));
        if (!result.cycle.isEmpty()) {
            output.setReturnValue("witness_firing_sequence_cycle", FiringSequence.class, new FiringSequence((Collection<Transition>)result.cycle));
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

