/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bounded;

import java.util.ArrayList;
import java.util.List;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.adt.pn.Transition;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class BoundedResult {
    public final PetriNet pn;
    public final Place unboundedPlace;
    public final Long k;
    public final List<Transition> sequence;
    public final List<Transition> cycle;

    public BoundedResult(PetriNet pn, Place place, Long k, List<Transition> sequenceToCovered, List<Transition> cycle) {
        this.pn = pn;
        this.unboundedPlace = place;
        this.k = k;
        this.sequence = sequenceToCovered;
        this.cycle = cycle;
    }

    public boolean isBounded() {
        return this.k != null;
    }

    public boolean isSafe() {
        return this.isKBounded(1);
    }

    public boolean isKBounded(int checkK) {
        return this.k != null && this.k <= (long)checkK;
    }

    public List<Transition> getSequenceExceeding(int n) {
        if (this.isKBounded(n) || n < 0) {
            return null;
        }
        Token target = Token.valueOf(n);
        Marking m = this.pn.getInitialMarking();
        ArrayList<Transition> result = new ArrayList<Transition>();
        if (m.getToken(this.unboundedPlace).compareTo(target) > 0) {
            return result;
        }
        Transition[] array = this.sequence.toArray(new Transition[0]);
        m = m.fireTransitions(array);
        result.addAll(this.sequence);
        array = this.cycle.toArray(new Transition[0]);
        while (m.getToken(this.unboundedPlace).compareTo(target) <= 0) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            result.addAll(this.cycle);
            m = m.fireTransitions(array);
        }
        return result;
    }
}

