/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bounded;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.bounded.BoundedResult;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Bounded {
    private Bounded() {
    }

    public static boolean isBounded(PetriNet pn) {
        return Bounded.checkBounded(pn).isBounded();
    }

    public static BoundedResult checkBounded(PetriNet pn) {
        Set<Place> places = pn.getPlaces();
        CoverabilityGraph cover = CoverabilityGraph.get(pn);
        List<Transition> sequence = new FiringSequence();
        Place witness = null;
        long k = 0L;
        for (CoverabilityGraphNode n : cover.getNodes()) {
            Marking mark = n.getMarking();
            for (Place p : places) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                Token val = mark.getToken(p);
                if (val.isOmega()) {
                    CoverabilityGraphNode covered = n.getCoveredNode();
                    return new BoundedResult(pn, p, null, covered.getFiringSequence(), n.getFiringSequenceFromCoveredNode());
                }
                if (k >= val.getValue()) continue;
                witness = p;
                sequence = n.getFiringSequence();
                k = val.getValue();
            }
        }
        return new BoundedResult(pn, witness, k, sequence, Collections.emptyList());
    }
}

