/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bisimulation;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.analysis.bisimulation.Bisimulation;
import uniol.apt.analysis.bisimulation.NonBisimilarPath;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class BisimulationModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "bisimulation";
    }

    @Override
    public String getShortDescription() {
        return "Check if the reachability graphs of two bounded labeled Petri nets or of two LTS or a combination of both are bisimilar";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pnOrLts1", PetriNetOrTransitionSystem.class, "The first Petri net that should be examined", new String[0]);
        inputSpec.addParameter("pnOrLts2", PetriNetOrTransitionSystem.class, "The second Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("bisimilar_graphs", Boolean.class, "success");
        outputSpec.addReturnValue("non_bisimilar_path", NonBisimilarPath.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem pnOrLts1 = input.getParameter("pnOrLts1", PetriNetOrTransitionSystem.class);
        PetriNetOrTransitionSystem pnOrLts2 = input.getParameter("pnOrLts2", PetriNetOrTransitionSystem.class);
        Bisimulation bisimulation = new Bisimulation();
        Boolean bisimilar = bisimulation.checkBisimulation(pnOrLts1.getReachabilityLTS(), pnOrLts2.getReachabilityLTS());
        output.setReturnValue("bisimilar_graphs", Boolean.class, bisimilar);
        output.setReturnValue("non_bisimilar_path", NonBisimilarPath.class, bisimulation.getErrorPath());
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

