/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bisimulation;

import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.bisimulation.NonBisimilarPath;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Bisimulation {
    private Set<Pair<State, State>> w;
    private Result result;
    private TransitionSystem lts1;
    private TransitionSystem lts2;
    private LinkedList<Pair<State, State>> errorPath;

    public Boolean checkBisimulation(TransitionSystem ltsOne, TransitionSystem ltsTwo) {
        this.lts1 = ltsOne;
        this.lts2 = ltsTwo;
        Deterministic lts1Deterministic = new Deterministic(this.lts1);
        Deterministic lts2Deterministic = new Deterministic(this.lts2);
        for (State s : ltsOne.getNodes()) {
            s.putExtension("label", "");
        }
        for (State s : ltsTwo.getNodes()) {
            s.putExtension("label", "");
        }
        if (lts1Deterministic.isDeterministic() || lts2Deterministic.isDeterministic()) {
            return this.checkDeterministicCase();
        }
        return this.checkGeneralCase();
    }

    public NonBisimilarPath getErrorPath() {
        if (this.errorPath != null) {
            return new NonBisimilarPath((List<Pair<State, State>>)this.errorPath);
        }
        return null;
    }

    private Boolean checkDeterministicCase() {
        this.errorPath = null;
        this.w = new HashSet<Pair<State, State>>();
        LinkedList<Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>> stack1 = new LinkedList<Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>>();
        Pair<State, State> initialPair = new Pair<State, State>(this.lts1.getInitialState(), this.lts2.getInitialState());
        this.w.add(initialPair);
        stack1.push(new Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>(initialPair, this.getSuccessors(initialPair)));
        while (!stack1.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            List l = (List)((Pair)stack1.peek()).getSecond();
            if (!l.isEmpty()) {
                Pair firstOfL = (Pair)l.remove(0);
                Pair tuple2 = (Pair)firstOfL.getSecond();
                Pair<Pair, List<Pair<Arc, Pair<State, State>>>> newElement = new Pair<Pair, List<Pair<Arc, Pair<State, State>>>>(tuple2, this.getSuccessors(tuple2));
                boolean hasFailSuccessor = false;
                for (Pair<Arc, Pair<State, State>> pair : newElement.getSecond()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    if (!pair.getFirst().getLabel().equals("phi") || !pair.getSecond().getFirst().getExtension("label").equals("fail") || pair.getSecond().getSecond() != null) continue;
                    hasFailSuccessor = true;
                    break;
                }
                if (!hasFailSuccessor) {
                    if (this.w.contains(tuple2)) continue;
                    this.w.add(tuple2);
                    stack1.push(newElement);
                    continue;
                }
                this.errorPath = new LinkedList();
                this.constructErrorPathPairs(stack1);
                if (!((Arc)firstOfL.getFirst()).getLabel().equals("phi") || !((State)tuple2.getFirst()).getExtension("label").equals("fail") || tuple2.getSecond() != null) {
                    this.errorPath.add(tuple2);
                }
                return false;
            }
            stack1.pop();
        }
        return true;
    }

    private Boolean checkGeneralCase() {
        this.w = new HashSet<Pair<State, State>>();
        this.result = Result.UNRELIABLE;
        while (this.result == Result.UNRELIABLE) {
            this.result = this.getResultOfPartialDFS();
        }
        return this.result != Result.FALSE;
    }

    /*
     * Could not resolve type clashes
     */
    private Result getResultOfPartialDFS() {
        Map m;
        this.errorPath = null;
        HashSet<Pair> visited = new HashSet<Pair>();
        HashSet<Pair> r = new HashSet<Pair>();
        boolean stable = false;
        LinkedList<Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>> stack1 = new LinkedList<Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>>();
        LinkedList<Map<Object, Object>> stack2 = new LinkedList<Map<Object, Object>>();
        Pair<State, State> initialPair = new Pair<State, State>(this.lts1.getInitialState(), this.lts2.getInitialState());
        stack1.push(new Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>(initialPair, this.getSuccessors(initialPair)));
        HashMap<State, Integer> mapForInitialPair = new HashMap<State, Integer>();
        mapForInitialPair.put(initialPair.getFirst(), 0);
        mapForInitialPair.put(initialPair.getSecond(), 0);
        stack2.push(mapForInitialPair);
        stack2.push(this.getMapforPostsetNodes(initialPair));
        while (!stack1.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            stable = true;
            Pair topStack1 = (Pair)stack1.peek();
            Pair testPair = (Pair)topStack1.getFirst();
            List l = (List)topStack1.getSecond();
            m = (Map)stack2.peek();
            if (!l.isEmpty()) {
                Pair firstOfL = (Pair)l.remove(0);
                Pair tuple2 = (Pair)firstOfL.getSecond();
                if (!visited.contains(tuple2) && !this.w.contains(tuple2)) {
                    Pair<Pair, List<Pair<Arc, Pair<State, State>>>> newElement = new Pair<Pair, List<Pair<Arc, Pair<State, State>>>>(tuple2, this.getSuccessors(tuple2));
                    boolean isInStack1 = false;
                    for (Object t : stack1) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        if (!((Pair)((Pair)t).getFirst()).equals(tuple2)) continue;
                        isInStack1 = true;
                    }
                    if (!isInStack1) {
                        Object t;
                        boolean hasFailSuccessor = false;
                        t = ((List)newElement.getSecond()).iterator();
                        while (t.hasNext()) {
                            Pair pair = (Pair)t.next();
                            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                            if (!((Arc)pair.getFirst()).getLabel().equals("phi") || !((State)((Pair)pair.getSecond()).getFirst()).getExtension("label").equals("fail") || ((Pair)pair.getSecond()).getSecond() != null) continue;
                            hasFailSuccessor = true;
                            break;
                        }
                        if (hasFailSuccessor) continue;
                        stack1.push((Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>)newElement);
                        stack2.push(this.getMapforPostsetNodes((Pair)newElement.getFirst()));
                        continue;
                    }
                    r.add(tuple2);
                    m.put(tuple2.getFirst(), 1);
                    m.put(tuple2.getSecond(), 1);
                    continue;
                }
                if (this.w.contains(tuple2)) continue;
                m.put(tuple2.getFirst(), 1);
                m.put(tuple2.getSecond(), 1);
                continue;
            }
            stack2.pop();
            visited.add(testPair);
            Map m2 = (Map)stack2.peek();
            boolean allOne = true;
            for (Integer i : m.values()) {
                if (i == 1) continue;
                allOne = false;
            }
            if (allOne) {
                m2.put(testPair.getFirst(), 1);
                m2.put(testPair.getSecond(), 1);
            } else {
                this.w.add(testPair);
                if (r.contains(testPair)) {
                    stable = false;
                }
                if (this.errorPath == null) {
                    this.errorPath = new LinkedList();
                    this.constructErrorPathPairs(stack1);
                    List<Pair<Arc, Pair<State, State>>> nonBisimilarElements = this.getSuccessors(testPair);
                    for (Pair<Arc, Pair<State, State>> pair : nonBisimilarElements) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        if (pair.getFirst().getLabel().equals("phi") && pair.getSecond().getFirst().getExtension("label").equals("fail") && pair.getSecond().getSecond() == null || (Integer)m.get(pair.getSecond().getFirst()) != 0 && (Integer)m.get(pair.getSecond().getSecond()) != 0) continue;
                        boolean hasNonBisimilarPairFind = false;
                        List<Pair<Arc, Pair<State, State>>> testElements = this.getSuccessors(pair.getSecond());
                        for (Pair<Arc, Pair<State, State>> nodePair : testElements) {
                            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                            if (!nodePair.getFirst().getLabel().equals("phi") || !nodePair.getSecond().getFirst().getExtension("label").equals("fail") || nodePair.getSecond().getSecond() != null) continue;
                            hasNonBisimilarPairFind = true;
                            break;
                        }
                        if (!hasNonBisimilarPairFind) continue;
                        this.errorPath.add(pair.getSecond());
                        break;
                    }
                }
            }
            stack1.pop();
        }
        m = (Map)stack2.peek();
        if ((Integer)m.get(initialPair.getFirst()) != 1 && (Integer)m.get(initialPair.getSecond()) != 1) {
            return Result.FALSE;
        }
        if (stable) {
            return Result.TRUE;
        }
        return Result.UNRELIABLE;
    }

    private List<Pair<Arc, Pair<State, State>>> getSuccessors(Pair<State, State> pair) {
        Arc phi;
        boolean isConcatenated;
        LinkedList<Pair<Arc, Pair<State, State>>> successors = new LinkedList<Pair<Arc, Pair<State, State>>>();
        if (pair.getFirst().getExtension("label").equals("fail")) {
            Arc phi2 = ((TransitionSystem)pair.getFirst().getGraph()).createArc(pair.getFirst().getId(), pair.getFirst().getId(), "phi");
            successors.add(new Pair<Arc, Pair<State, State>>(phi2, pair));
            return successors;
        }
        Set<Arc> node1PostsetEdges = pair.getFirst().getPostsetEdges();
        Set<Arc> node2PostsetEdges = pair.getSecond().getPostsetEdges();
        State fail1 = this.lts1.createState();
        State fail2 = this.lts2.createState();
        fail1.putExtension("label", "fail");
        fail2.putExtension("label", "fail");
        boolean isConcatenatedWithFail = false;
        for (Arc edge1 : node1PostsetEdges) {
            isConcatenated = false;
            for (Arc edge2 : node2PostsetEdges) {
                if (!edge1.getLabel().equals(edge2.getLabel())) continue;
                successors.add(new Pair(edge1, new Pair(edge1.getTarget(), edge2.getTarget())));
                isConcatenated = true;
            }
            if (isConcatenated || isConcatenatedWithFail) continue;
            State copyOfEdge1PostNode = ((TransitionSystem)((State)edge1.getTarget()).getGraph()).createState();
            copyOfEdge1PostNode.putExtension("label", ((State)edge1.getTarget()).getExtension("label"));
            phi = this.lts1.createArc(copyOfEdge1PostNode, fail1, "");
            phi.setLabel("phi");
            successors.add(new Pair<Arc, Pair<State, Object>>(phi, new Pair<State, Object>(fail1, null)));
            isConcatenatedWithFail = true;
        }
        for (Arc edge2 : node2PostsetEdges) {
            isConcatenated = false;
            for (Arc edgeNode1 : node1PostsetEdges) {
                if (!edge2.getLabel().equals(edgeNode1.getLabel())) continue;
                isConcatenated = true;
                break;
            }
            if (isConcatenated || isConcatenatedWithFail) continue;
            State copyOfEdge2PostNode = ((TransitionSystem)((State)edge2.getTarget()).getGraph()).createState();
            copyOfEdge2PostNode.putExtension("label", ((State)edge2.getTarget()).getExtension("label"));
            phi = this.lts2.createArc(copyOfEdge2PostNode, fail2, "");
            phi.setLabel("phi");
            successors.add(new Pair<Arc, Pair<State, Object>>(phi, new Pair<State, Object>(fail2, null)));
            isConcatenatedWithFail = true;
        }
        return successors;
    }

    private Map<State, Integer> getMapforPostsetNodes(Pair<State, State> pair) {
        HashMap<State, Integer> hashMap = new HashMap<State, Integer>();
        for (State node : pair.getFirst().getPostsetNodes()) {
            hashMap.put(node, 0);
        }
        for (State node : pair.getSecond().getPostsetNodes()) {
            hashMap.put(node, 0);
        }
        return hashMap;
    }

    private List<Pair<State, State>> constructErrorPathPairs(Deque<Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>>> stack) {
        for (Pair<Pair<State, State>, List<Pair<Arc, Pair<State, State>>>> element : stack) {
            this.errorPath.addFirst(element.getFirst());
        }
        return this.errorPath;
    }

    private static enum Result {
        TRUE,
        FALSE,
        UNRELIABLE;

    }
}

