/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bcf;

import java.util.Collection;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.bcf.BCF;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class BCFModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net is behaviourally conflict free (BCF)";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nA Petri net is BCF if in every reachable marking M and for any enabled pair of transitions (M[a>, M[b> and a \u2260 b), the presets of the transitions is disjoint (\u00b0a\u2229\u00b0b=\u2205).";
    }

    @Override
    public String getName() {
        return "bcf";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("bcf", Boolean.class, "success");
        outputSpec.addReturnValue("witness_marking", Marking.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence", FiringSequence.class, new String[0]);
        outputSpec.addReturnValue("witness_transition1", Transition.class, new String[0]);
        outputSpec.addReturnValue("witness_transition2", Transition.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        BCF.Result result = new BCF().check(pn);
        output.setReturnValue("bcf", Boolean.class, result == null);
        if (result != null) {
            FiringSequence firingSequence = new FiringSequence((Collection<Transition>)result.sequence);
            output.setReturnValue("witness_marking", Marking.class, result.m);
            output.setReturnValue("witness_firing_sequence", FiringSequence.class, firingSequence);
            output.setReturnValue("witness_transition1", Transition.class, result.t1);
            output.setReturnValue("witness_transition2", Transition.class, result.t2);
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

