/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.bcf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class BCF {
    public Result check(PetriNet pn) throws UnboundedException {
        CoverabilityGraph cover = CoverabilityGraph.get(pn);
        for (CoverabilityGraphNode node : cover.getNodes()) {
            HashSet<CoverabilityGraphEdge> edges = new HashSet<CoverabilityGraphEdge>(node.getPostsetEdges());
            Marking marking = node.getMarking();
            if (marking.hasOmega()) {
                throw new UnboundedException(marking.getNet());
            }
            while (!edges.isEmpty()) {
                Iterator it = edges.iterator();
                CoverabilityGraphEdge edge1 = (CoverabilityGraphEdge)it.next();
                Transition trans1 = edge1.getTransition();
                it.remove();
                for (CoverabilityGraphEdge edge2 : edges) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    Transition trans2 = edge2.getTransition();
                    assert (edge1 != edge2);
                    if (this.check(marking, trans1, trans2)) continue;
                    return new Result(marking, node.getFiringSequence(), trans1, trans2);
                }
            }
        }
        return null;
    }

    protected boolean check(Marking mark, Transition t1, Transition t2) {
        return Collections.disjoint(t1.getPreset(), t2.getPreset());
    }

    public static class Result {
        public final Transition t1;
        public final Transition t2;
        public final Marking m;
        public final List<Transition> sequence;

        Result(Marking m, List<Transition> sequence, Transition t1, Transition t2) {
            this.m = m;
            this.sequence = sequence;
            this.t1 = t1;
            this.t2 = t2;
        }
    }
}

