/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.algebra;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.algebra.Matrix;
import uniol.apt.analysis.algebra.MatrixFileFormat;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class MatrixModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "matrices";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("format", MatrixFileFormat.class, "The file format of the printed matrices", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("backward_matrix", String[][].class, new String[0]);
        outputSpec.addReturnValue("forward_matrix", String[][].class, new String[0]);
        outputSpec.addReturnValue("incidence_matrix", String[][].class, new String[0]);
        outputSpec.addReturnValue("output", String.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        MatrixFileFormat format = input.getParameter("format", MatrixFileFormat.class);
        Matrix matrix = new Matrix(pn);
        if (format == null) {
            output.setReturnValue("backward_matrix", String[][].class, matrix.getStringBackward());
            output.setReturnValue("forward_matrix", String[][].class, matrix.getStringForward());
            output.setReturnValue("incidence_matrix", String[][].class, matrix.getStringIncidence());
            return;
        }
        switch (format) {
            case MATLAB: {
                output.setReturnValue("output", String.class, matrix.getMatLabMatrices() + "\n");
                return;
            }
            case R: {
                output.setReturnValue("output", String.class, matrix.getRMatrices() + "\n");
                return;
            }
        }
        throw new ModuleException("Unknown format: " + (Object)((Object)format));
    }

    @Override
    public String getShortDescription() {
        return "Calculate forward, backward, and incidence matrices.";
    }

    @Override
    public String getLongDescription() {
        return "Calculate forward, backward, and incidence matrices. The matrices can also be printed in the R and MATLAB format.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

