/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.algebra;

import java.util.ArrayList;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class Matrix {
    private final String[][] matrix;
    private final PetriNet pn;

    public Matrix(PetriNet net) {
        this.pn = net;
        this.matrix = new String[this.pn.getPlaces().size() + 1][this.pn.getTransitions().size() + 1];
        this.matrix[0][0] = " M";
        int placeStart = 1;
        for (Place p : this.pn.getPlaces()) {
            this.matrix[placeStart][0] = p.getId();
            ++placeStart;
        }
        int transStart = 1;
        for (Transition t : this.pn.getTransitions()) {
            this.matrix[0][transStart] = t.getId();
            ++transStart;
        }
    }

    public String[][] getStringForward() {
        int j;
        int i;
        String[][] result = new String[this.pn.getPlaces().size() + 1][this.pn.getTransitions().size() + 1];
        for (i = 0; i < this.matrix.length; ++i) {
            for (j = 0; j < this.matrix[0].length; ++j) {
                String value;
                result[i][j] = value = this.matrix[i][j];
            }
        }
        result[0][0] = "F";
        for (i = 1; i < this.matrix.length; ++i) {
            for (j = 1; j < this.matrix[0].length; ++j) {
                String place = this.matrix[i][0];
                String transition = this.matrix[0][j];
                result[i][j] = "0";
                for (Flow arc : this.pn.getEdges()) {
                    if (!place.equals(((Node)arc.getTarget()).getId()) || !transition.equals(((Node)arc.getSource()).getId())) continue;
                    result[i][j] = String.valueOf(arc.getWeight());
                }
            }
        }
        return result;
    }

    public String[][] getStringBackward() {
        int j;
        int i;
        String[][] result = new String[this.pn.getPlaces().size() + 1][this.pn.getTransitions().size() + 1];
        for (i = 0; i < this.matrix.length; ++i) {
            for (j = 0; j < this.matrix[0].length; ++j) {
                String value;
                result[i][j] = value = this.matrix[i][j];
            }
        }
        result[0][0] = "B";
        for (i = 1; i < this.matrix.length; ++i) {
            for (j = 1; j < this.matrix[0].length; ++j) {
                String place = this.matrix[i][0];
                String transition = this.matrix[0][j];
                result[i][j] = "0";
                for (Flow arc : this.pn.getEdges()) {
                    if (!place.equals(((Node)arc.getSource()).getId()) || !transition.equals(((Node)arc.getTarget()).getId())) continue;
                    result[i][j] = String.valueOf(arc.getWeight());
                }
            }
        }
        return result;
    }

    public String[][] getStringIncidence() {
        String[][] result = new String[this.pn.getPlaces().size() + 1][this.pn.getTransitions().size() + 1];
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                String value;
                result[i][j] = value = this.matrix[i][j];
            }
        }
        result[0][0] = "C";
        String[][] backward = this.getStringBackward();
        String[][] forward = this.getStringForward();
        for (int i = 1; i < result.length; ++i) {
            for (int j = 1; j < result[0].length; ++j) {
                result[i][j] = String.valueOf(Integer.parseInt(forward[i][j]) - Integer.parseInt(backward[i][j]));
            }
        }
        return result;
    }

    public String getRMatrices() {
        StringBuilder result = new StringBuilder();
        Matrix.getRMatricesHelper(result, this.getStringForward(), "forward");
        Matrix.getRMatricesHelper(result, this.getStringBackward(), "backward");
        Matrix.getRMatricesHelper(result, this.getStringIncidence(), "incidence");
        return result.toString();
    }

    private static void getRMatricesHelper(StringBuilder result, String[][] matrix, String typ) {
        int i;
        int i2;
        for (i2 = 1; i2 < matrix.length; ++i2) {
            result.append("row").append(typ).append(i2).append(" <- c(");
            for (int j = 1; j < matrix[0].length; ++j) {
                if (j != matrix[0].length - 1) {
                    result.append(matrix[i2][j]).append(",");
                    continue;
                }
                result.append(matrix[i2][j]).append(")");
            }
            result.append("\n");
        }
        result.append(typ).append(" <- matrix(c(");
        for (i2 = 1; i2 < matrix.length; ++i2) {
            if (i2 != matrix.length - 1) {
                result.append("row").append(typ).append(i2).append(",");
                continue;
            }
            result.append("row").append(i2).append("),");
            result.append(matrix.length - 1).append(") \n");
        }
        ArrayList<String> colnames = new ArrayList<String>();
        ArrayList<String> dimnames = new ArrayList<String>();
        for (int j = 0; j < matrix.length; ++j) {
            for (int j2 = 0; j2 < matrix[0].length - 1; ++j2) {
                if (j == 0) {
                    colnames.add(matrix[j][j2 + 1]);
                    continue;
                }
                if (j2 != 0 || j == 0) continue;
                dimnames.add(matrix[j][j2]);
            }
        }
        result.append("colnames(").append(typ).append(") <- c(");
        for (i = 0; i < colnames.size(); ++i) {
            if (i != colnames.size() - 1) {
                result.append("\"").append((String)colnames.get(i)).append("\", ");
                continue;
            }
            result.append("\"").append((String)colnames.get(i)).append("\"");
        }
        result.append(") \n");
        result.append("dimnames(").append(typ).append(") <- list(c(");
        for (i = 0; i < dimnames.size(); ++i) {
            if (i != dimnames.size() - 1) {
                result.append("\"").append((String)dimnames.get(i)).append("\", ");
                continue;
            }
            result.append("\"").append((String)dimnames.get(i)).append("\"");
        }
        result.append(")) \n \n");
    }

    public String getMatLabMatrices() {
        StringBuilder result = new StringBuilder();
        for (int h = 0; h < 3; ++h) {
            String[][] tmp = null;
            if (h == 0) {
                tmp = this.getStringForward();
                result.append("forward=[");
            }
            if (h == 1) {
                tmp = this.getStringBackward();
                result.append("\nbackward=[");
            }
            if (h == 2) {
                tmp = this.getStringIncidence();
                result.append("\nincidence=[");
            }
            for (int i = 0; i < tmp.length; ++i) {
                for (int j = 0; j < tmp[0].length; ++j) {
                    if (j == tmp[0].length - 1) {
                        result.append(tmp[i][j]).append("; ");
                        continue;
                    }
                    result.append(tmp[i][j]).append(", ");
                }
            }
            result.append("]");
        }
        return result.toString();
    }
}

