/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.ac;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.analysis.ac.AsymmetricChoice;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.Pair;

public class AsymmetricChoiceModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "ac";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("ac", Boolean.class, "success");
        outputSpec.addReturnValue("witness1", Place.class, new String[0]);
        outputSpec.addReturnValue("witness2", Place.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        AsymmetricChoice ac = new AsymmetricChoice();
        PetriNet pn = input.getParameter("net", PetriNet.class);
        Pair<Place, Place> counterexample = ac.check(pn);
        output.setReturnValue("ac", Boolean.class, counterexample == null);
        if (counterexample != null) {
            output.setReturnValue("witness1", Place.class, counterexample.getFirst());
            output.setReturnValue("witness2", Place.class, counterexample.getSecond());
        }
    }

    @Override
    public String getTitle() {
        return "Asymmetric Choice";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is asymmetric-choice";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nA Petri net is an asymmetric choice net if \u2200p\u2081,p\u2082\u2208P: p\u2081\u00b0\u2229p\u2082\u00b0\u2260\u2205 \u21d2 p\u2081\u00b0\u2286p\u2082\u00b0 \u2228 p\u2081\u00b0\u2287p\u2082\u00b0";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

