/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis;

import uniol.apt.adt.automaton.FiniteAutomaton;
import uniol.apt.adt.automaton.FiniteAutomatonUtility;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class RegularLanguageToLTSModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Represent a regular language as a transition system";
    }

    @Override
    public String getName() {
        return "regular_language_to_lts";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lang", FiniteAutomaton.class, "The regular language to transform", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("lts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        FiniteAutomaton aut = input.getParameter("lang", FiniteAutomaton.class);
        TransitionSystem ts = FiniteAutomatonUtility.prefixLanguageLTS(FiniteAutomatonUtility.minimize(aut));
        output.setReturnValue("lts", TransitionSystem.class, ts);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

