/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.GenerateStepNet;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class GenerateStepNetModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Calculate the concurrent coverability graph of a Petri net in the step semantics";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". In the step semantics, instead of individual transitions, sets of transitions called 'a step' are fired. When a step fires, first all of its transition consume token and only afterwards produce tokens. Put differently, on each place at least as many token have to be present as the sum of the arc weights of the transitions in a step require.";
    }

    @Override
    public String getName() {
        return "concurrent_coverability_graph";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("dot", String.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        String dot = new GenerateStepNet(pn).renderCoverabilityGraphAsDot();
        output.setReturnValue("dot", String.class, dot);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

