/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.util.PowerSet;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class GenerateStepNet {
    public static final String TRANSITIONS_KEY = "TransitionsOfStep";
    public static final String TS_NODE_TEMPLATE = "%1$s[label=\"%2$s\"]; // node for marking %3$s%n";
    public static final String TS_INIT_TEMPLATE = "%1$s[label=\"%2$s\", shape=circle]; // node for marking %3$s%n";
    public static final String TS_EDGE_TEMPLATE = "%1$s -> %2$s[label=\"%3$s\"];%n";
    private final PetriNet pn;
    private final PetriNet stepNet;
    private final Collection<Marking> maximalReachableMarkings;
    private final Collection<Collection<Transition>> disabledSteps = new LinkedList<Collection<Transition>>();

    public GenerateStepNet(PetriNet pn) {
        this.pn = pn;
        this.maximalReachableMarkings = GenerateStepNet.getMaximalReachableMarkings(pn);
        this.stepNet = this.generateStepNet();
    }

    public PetriNet getStepNet() {
        return this.stepNet;
    }

    public static String getStepLabel(Collection<Transition> transitions) {
        StringBuilder result = new StringBuilder("{");
        boolean first = true;
        for (Transition t : transitions) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(t.getId());
        }
        result.append("}");
        return result.toString();
    }

    public static boolean isMarkingLessOrEqual(Marking mark1, Marking mark2) {
        for (Place p : mark1.getNet().getPlaces()) {
            int cmp = mark1.getToken(p).compareTo(mark2.getToken(p));
            if (cmp <= 0) continue;
            return false;
        }
        return true;
    }

    public static Collection<Marking> getMaximalReachableMarkings(PetriNet pn) {
        HashSet<Marking> result = new HashSet<Marking>();
        for (CoverabilityGraphNode node : CoverabilityGraph.get(pn).getNodes()) {
            Marking mark = node.getMarking();
            Iterator iter = result.iterator();
            boolean skip = false;
            while (iter.hasNext()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                Marking mark2 = (Marking)iter.next();
                if (GenerateStepNet.isMarkingLessOrEqual(mark, mark2)) {
                    skip = true;
                    break;
                }
                if (!GenerateStepNet.isMarkingLessOrEqual(mark2, mark)) continue;
                iter.remove();
            }
            if (skip) continue;
            result.add(mark);
        }
        return result;
    }

    public boolean isStepReasonable(Collection<Transition> transitions) {
        if (transitions.isEmpty()) {
            return false;
        }
        LinkedList<Collection<Transition>> disabledStepsToRemove = new LinkedList<Collection<Transition>>();
        for (Collection<Transition> disabledStep : this.disabledSteps) {
            if (transitions.containsAll(disabledStep)) {
                assert (disabledStepsToRemove.isEmpty());
                return false;
            }
            if (!disabledStep.containsAll(transitions)) continue;
            disabledStepsToRemove.add(disabledStep);
        }
        HashMap<Place, Token> requiredToken = new HashMap<Place, Token>();
        for (Place place : this.pn.getPlaces()) {
            int requiredOnPlace = 0;
            for (Flow flow : place.getPostsetEdges()) {
                if (!transitions.contains(flow.getTarget())) continue;
                requiredOnPlace += flow.getWeight();
            }
            requiredToken.put(place, Token.valueOf(requiredOnPlace));
        }
        for (Marking mark : this.maximalReachableMarkings) {
            boolean enabled = true;
            for (Map.Entry entry : requiredToken.entrySet()) {
                if (mark.getToken((Place)entry.getKey()).compareTo((Token)entry.getValue()) >= 0) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            return true;
        }
        this.disabledSteps.add(transitions);
        this.disabledSteps.removeAll(disabledStepsToRemove);
        return false;
    }

    private PetriNet generateStepNet() {
        PetriNet result = new PetriNet("Step net of " + this.pn.getName());
        HashMap<Place, Place> placeMap = new HashMap<Place, Place>();
        for (Place place : this.pn.getPlaces()) {
            placeMap.put(place, result.createPlace(place));
        }
        result.setInitialMarking(new Marking(result, this.pn.getInitialMarking()));
        for (Collection collection : PowerSet.powerSet(new ArrayList<Transition>(this.pn.getTransitions()))) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!this.isStepReasonable(collection)) continue;
            Transition t = result.createTransition();
            t.putExtension(TRANSITIONS_KEY, GenerateStepNet.getStepLabel(collection));
            for (Place place : this.pn.getPlaces()) {
                int backwardWeight = 0;
                int forwardWeight = 0;
                for (Flow flow : place.getPostsetEdges()) {
                    if (!collection.contains(flow.getTarget())) continue;
                    forwardWeight += flow.getWeight();
                }
                for (Flow flow : place.getPresetEdges()) {
                    if (!collection.contains(flow.getSource())) continue;
                    backwardWeight += flow.getWeight();
                }
                result.createFlow((Node)placeMap.get(place), t, forwardWeight);
                result.createFlow(t, (Node)placeMap.get(place), backwardWeight);
            }
        }
        return result;
    }

    public String renderCoverabilityGraphAsDot() {
        CoverabilityGraph graph = CoverabilityGraph.get(this.getStepNet());
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n");
        sb.append("node [shape = point, color=white, fontcolor=white]; start;");
        sb.append("edge [fontsize=20]\n");
        sb.append("node [fontsize=20,shape=circle,color=black,fontcolor=black,height=0.5,width=0.5,fixedsize=true];\n");
        Formatter format = new Formatter(sb);
        HashMap<CoverabilityGraphNode, String> nodeLabels = new HashMap<CoverabilityGraphNode, String>();
        nodeLabels.put(graph.getInitialNode(), "s0");
        format.format(TS_INIT_TEMPLATE, "s0", "s0", graph.getInitialNode().getMarking().toString());
        int nextState = 1;
        for (CoverabilityGraphNode node : graph.getNodes()) {
            if (graph.getInitialNode().equals(node)) continue;
            String name = "s" + nextState++;
            nodeLabels.put(node, name);
            format.format(TS_NODE_TEMPLATE, name, name, node.getMarking().toString());
        }
        format.format(TS_EDGE_TEMPLATE, "start", "s0", "");
        for (CoverabilityGraphEdge edge : graph.getEdges()) {
            String source = (String)nodeLabels.get(edge.getSource());
            String target = (String)nodeLabels.get(edge.getTarget());
            String label = edge.getTransition().getExtension(TRANSITIONS_KEY).toString();
            format.format(TS_EDGE_TEMPLATE, source, target, label);
        }
        format.close();
        sb.append("}\n");
        return sb.toString();
    }
}

