/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis;

import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.exception.TransitionFireException;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.analysis.language.Word;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class FireSequenceModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Try to fire a given firing sequence on a Petri net.";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". This module tries to fire a given sequence of transitions in a Petri net. It will report the longest enabled prefix of the sequence and print the marking that is reached at the end.";
    }

    @Override
    public String getName() {
        return "fire_sequence";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("sequence", Word.class, "Sequence that should be fired", new String[0]);
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("success", Boolean.class, "success");
        outputSpec.addReturnValue("reached_marking", Marking.class, new String[0]);
        outputSpec.addReturnValue("fired_sequence", FiringSequence.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        Word sequence = input.getParameter("sequence", Word.class);
        Marking marking = pn.getInitialMarking();
        FiringSequence fired = new FiringSequence();
        boolean success = true;
        try {
            for (String name : sequence) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                Transition trans = pn.getTransition(name);
                marking = trans.fire(marking);
                fired.add(trans);
            }
            fired = null;
        }
        catch (NoSuchNodeException e) {
            String msg = "No transition named '" + e.getNodeId() + "' exists";
            throw new ModuleException(msg, e);
        }
        catch (TransitionFireException e) {
            success = false;
        }
        output.setReturnValue("success", Boolean.class, success);
        output.setReturnValue("reached_marking", Marking.class, marking);
        output.setReturnValue("fired_sequence", FiringSequence.class, fired);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

