/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis;

import java.util.Set;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.analysis.reversible.ReversibleTS;
import uniol.apt.analysis.totallyreachable.TotallyReachable;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ExamineLTSModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Perform various tests on a transition system at once";
    }

    @Override
    public String getName() {
        return "examine_lts";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("num_states", Integer.class, new String[0]);
        outputSpec.addReturnValue("num_arcs", Integer.class, new String[0]);
        outputSpec.addReturnValue("num_labels", Integer.class, new String[0]);
        outputSpec.addReturnValue("deterministic", Boolean.class, new String[0]);
        outputSpec.addReturnValue("backwards_deterministic", Boolean.class, new String[0]);
        outputSpec.addReturnValue("persistent", Boolean.class, new String[0]);
        outputSpec.addReturnValue("backwards_persistent", Boolean.class, new String[0]);
        outputSpec.addReturnValue("totally_reachable", Boolean.class, new String[0]);
        outputSpec.addReturnValue("reversible", Boolean.class, new String[0]);
        outputSpec.addReturnValue("isolated_elements", Boolean.class, new String[0]);
        outputSpec.addReturnValue("strongly_connected", Boolean.class, new String[0]);
        outputSpec.addReturnValue("weakly_connected", Boolean.class, new String[0]);
        outputSpec.addReturnValue("same_parikh_vectors", Boolean.class, new String[0]);
        outputSpec.addReturnValue("same_or_mutually_disjoint_pv", Boolean.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem lts = input.getParameter("lts", TransitionSystem.class);
        Deterministic det = new Deterministic(lts);
        Deterministic bDet = new Deterministic(lts, false);
        PersistentTS per = new PersistentTS(lts);
        PersistentTS backwardsPer = new PersistentTS(lts, true);
        TotallyReachable tot = new TotallyReachable(lts);
        ReversibleTS rev = new ReversibleTS(lts);
        output.setReturnValue("num_states", Integer.class, lts.getNodes().size());
        output.setReturnValue("num_arcs", Integer.class, lts.getEdges().size());
        output.setReturnValue("num_labels", Integer.class, lts.getAlphabet().size());
        output.setReturnValue("deterministic", Boolean.class, det.isDeterministic());
        output.setReturnValue("backwards_deterministic", Boolean.class, bDet.isDeterministic());
        output.setReturnValue("persistent", Boolean.class, per.isPersistent());
        output.setReturnValue("backwards_persistent", Boolean.class, backwardsPer.isPersistent());
        output.setReturnValue("totally_reachable", Boolean.class, tot.isTotallyReachable());
        output.setReturnValue("reversible", Boolean.class, rev.isReversible());
        output.setReturnValue("isolated_elements", Boolean.class, !Connectivity.findIsolatedElements(lts).isEmpty());
        output.setReturnValue("strongly_connected", Boolean.class, Connectivity.isStronglyConnected(lts));
        output.setReturnValue("weakly_connected", Boolean.class, Connectivity.isWeaklyConnected(lts));
        ComputeSmallestCycles csc = new ComputeSmallestCycles();
        Set<? extends CyclePV> vecs = csc.computePVsOfSmallestCycles(lts);
        output.setReturnValue("same_parikh_vectors", Boolean.class, csc.checkSamePVs(vecs));
        output.setReturnValue("same_or_mutually_disjoint_pv", Boolean.class, csc.checkSameOrMutallyDisjointPVs(vecs));
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

