/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.ts;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.iterators.EmptyIterator;
import uniol.apt.adt.AbstractGraph;
import uniol.apt.adt.CollectionToUnmodifiableSetAdapter;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.SoftMap;
import uniol.apt.adt.exception.ArcExistsException;
import uniol.apt.adt.exception.NoSuchEdgeException;
import uniol.apt.adt.exception.NoSuchEventException;
import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.exception.NodeExistsException;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ArcKey;
import uniol.apt.adt.ts.Event;
import uniol.apt.adt.ts.State;

public class TransitionSystem
extends AbstractGraph<TransitionSystem, Arc, State>
implements IGraph<TransitionSystem, Arc, State> {
    private String name;
    private int nextStateId = 0;
    private final SortedMap<String, State> states = new TreeMap<String, State>();
    private final Map<String, InternalEvent> alphabet = new HashMap<String, InternalEvent>();
    private final Set<Event> alphabetSet = new TreeSet<Event>();
    private final Map<String, Bag<State>> presetNodes = new SoftMap<String, Bag<State>>();
    private final Map<String, Bag<State>> postsetNodes = new SoftMap<String, Bag<State>>();
    private int numArcs = 0;
    private State initialState = null;

    public TransitionSystem() {
        this("");
    }

    public TransitionSystem(String name) {
        this.name = name;
    }

    public TransitionSystem(TransitionSystem ts) {
        this.name = ts.name;
        this.nextStateId = ts.nextStateId;
        for (Map.Entry<String, State> entry : ts.states.entrySet()) {
            this.addState(entry.getKey(), new State(this, entry.getValue()));
        }
        for (State source : ts.states.values()) {
            for (Map.Entry<ArcKey, Arc> entry : source.postsetEdges.entrySet()) {
                this.addEvent(entry.getValue().getEvent().getLabel());
                this.addArc(entry.getKey(), new Arc(this, entry.getValue()));
            }
        }
        for (Event event : this.alphabetSet) {
            event.copyExtensions(ts.getEvent(event.getLabel()));
        }
        this.initialState = (State)this.states.get(ts.getInitialState().getId());
        this.copyExtensions(ts);
    }

    public void setInitialState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state == null");
        }
        this.setInitialState(state.getId());
    }

    public void setInitialState(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        this.initialState = (State)this.states.get(id);
        this.invokeListeners();
        if (this.initialState == null) {
            throw new NoSuchNodeException(this, id);
        }
    }

    public State getInitialState() {
        if (this.initialState == null) {
            throw new StructureException("Initial state is not set in graph '" + this.getName() + "'.");
        }
        return this.initialState;
    }

    private Arc addArc(ArcKey key, Arc arc) {
        Bag<State> postNodes;
        State target = (State)arc.getTarget();
        State source = (State)arc.getSource();
        target.presetEdges.put(key, arc);
        source.postsetEdges.put(key, arc);
        ++this.numArcs;
        Bag<State> preNodes = this.presetNodes.get(target.getId());
        if (preNodes != null) {
            preNodes.add((State)arc.getSource());
        }
        if ((postNodes = this.postsetNodes.get(source.getId())) != null) {
            postNodes.add((State)arc.getTarget());
        }
        this.onArcAddedUpdateByLabelCache(arc);
        this.invokeListeners();
        return arc;
    }

    public Event getEvent(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        InternalEvent result = this.alphabet.get(label);
        if (result == null) {
            throw new NoSuchEventException(label);
        }
        return result.getEvent();
    }

    public Arc createArc(String sourceId, String targetId, String label) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        ArcKey key = this.createArcKey(sourceId, targetId, label);
        if (((State)this.states.get((Object)sourceId)).postsetEdges.containsKey(key)) {
            throw new ArcExistsException(this, key);
        }
        Arc a = new Arc(this, this.getNode(sourceId), this.getNode(targetId), this.addEvent(label));
        return this.addArc(key, a);
    }

    public Arc createArc(State source, State target, String label) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        return this.createArc(source.getId(), target.getId(), label);
    }

    public Arc createArc(Arc arc) {
        if (arc == null) {
            throw new IllegalArgumentException("arc == null");
        }
        Arc a = this.createArc(arc.getSourceId(), arc.getTargetId(), arc.getLabel());
        a.copyExtensions(arc);
        return a;
    }

    private State addState(String id, State state) {
        this.states.put(id, state);
        this.presetNodes.put(id, new HashBag());
        this.postsetNodes.put(id, new HashBag());
        this.invokeListeners();
        return state;
    }

    public State createState(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        State s = (State)this.states.get(id);
        if (s != null) {
            throw new NodeExistsException(this, id);
        }
        return this.addState(id, new State(this, id));
    }

    public State createState() {
        while (this.states.containsKey("s" + this.nextStateId)) {
            ++this.nextStateId;
        }
        State s = this.createState("s" + this.nextStateId);
        ++this.nextStateId;
        return s;
    }

    public State createState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state == null");
        }
        State s = this.createState(state.getId());
        s.copyExtensions(state);
        return s;
    }

    public State[] createStates(State ... stateList) {
        if (stateList == null) {
            throw new IllegalArgumentException("states == null");
        }
        State[] out = new State[stateList.length];
        for (int i = 0; i < stateList.length; ++i) {
            out[i] = this.createState(stateList[i]);
        }
        return out;
    }

    public State[] createStates(String ... idList) {
        if (idList == null) {
            throw new IllegalArgumentException("states == null");
        }
        State[] out = new State[idList.length];
        for (int i = 0; i < idList.length; ++i) {
            out[i] = this.createState(idList[i]);
        }
        return out;
    }

    public State[] createStates(int count) {
        State[] out = new State[count];
        for (int i = 0; i < count; ++i) {
            out[i] = this.createState();
        }
        return out;
    }

    public void removeArc(String sourceId, String targetId, String label) {
        Bag<State> postNodes;
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        ArcKey key = this.createArcKey(sourceId, targetId, label);
        Arc a = ((State)this.states.get((Object)sourceId)).postsetEdges.get(key);
        if (a == null) {
            throw new NoSuchEdgeException(this, sourceId, targetId);
        }
        Bag<State> preNodes = this.presetNodes.get(targetId);
        if (preNodes != null) {
            preNodes.remove(this.states.get(sourceId), 1);
        }
        if ((postNodes = this.postsetNodes.get(sourceId)) != null) {
            postNodes.remove(this.states.get(targetId), 1);
        }
        this.onArcRemovedUpdateByLabelCache(a);
        Arc old = ((State)this.states.get((Object)targetId)).presetEdges.remove(key);
        assert (old == a);
        old = ((State)this.states.get((Object)sourceId)).postsetEdges.remove(key);
        assert (old == a);
        --this.numArcs;
        this.removeEvent(a.getEvent());
        this.invokeListeners();
    }

    public void removeArc(Arc a) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (this != a.getGraph()) {
            throw new StructureException("arc '" + a.toString() + "' does not belong to the net '" + this.getName() + "'.");
        }
        this.removeArc(a.getSourceId(), a.getTargetId(), a.getLabel());
    }

    public void removeState(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        State state = (State)this.states.get(id);
        if (state == null) {
            throw new NoSuchNodeException(this, id);
        }
        HashSet<Arc> pe = new HashSet<Arc>(this.getPresetEdges(id));
        for (Arc a : pe) {
            this.removeArc(a);
        }
        pe = new HashSet<Arc>(this.getPostsetEdges(id));
        for (Arc a : pe) {
            this.removeArc(a);
        }
        this.presetNodes.remove(id);
        this.postsetNodes.remove(id);
        state.presetEdges.clear();
        state.postsetEdges.clear();
        state.postsetEdgesByLabel.clear();
        state.presetEdgesByLabel.clear();
        if (this.initialState != null && this.initialState.getId().equals(id)) {
            this.initialState = null;
        }
        this.states.remove(id);
        this.invokeListeners();
    }

    public void removeState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state == null");
        }
        if (this != state.getGraph()) {
            throw new StructureException("node'" + state.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        this.removeState(state.getId());
    }

    public Arc getArc(String sourceId, String targetId, String label) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        Arc a = ((State)this.states.get((Object)sourceId)).postsetEdges.get(this.createArcKey(sourceId, targetId, label));
        if (a == null) {
            throw new NoSuchEdgeException(this, sourceId, targetId, label);
        }
        return a;
    }

    public Arc getArc(State source, State target, String label) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        if (this != source.getGraph()) {
            throw new StructureException("source state '" + source.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        if (this != target.getGraph()) {
            throw new StructureException("target state '" + target.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        return this.getArc(source.getId(), target.getId(), label);
    }

    public Set<Event> getAlphabetEvents() {
        return Collections.unmodifiableSet(this.alphabetSet);
    }

    public Set<String> getAlphabet() {
        final Set<Event> events = this.alphabetSet;
        return new AbstractSet<String>(){

            @Override
            public int size() {
                return events.size();
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private Iterator<Event> it;
                    {
                        this.it = events.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public String next() {
                        return this.it.next().getLabel();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ArcKey createArcKey(String sourceId, String targetId, String label) {
        if (!this.states.containsKey(sourceId)) {
            throw new NoSuchNodeException(this, sourceId);
        }
        if (!this.states.containsKey(targetId)) {
            throw new NoSuchNodeException(this, targetId);
        }
        return new ArcKey(sourceId, targetId, label);
    }

    void setArcLabel(String sourceId, String targetId, Event oldEvent, String newLabel) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        if (newLabel == null) {
            throw new IllegalArgumentException("label == null");
        }
        Event newEvent = this.addEvent(newLabel);
        if (!oldEvent.equals(newEvent)) {
            ArcKey oldKey = this.createArcKey(sourceId, targetId, oldEvent.getLabel());
            ArcKey newKey = this.createArcKey(sourceId, targetId, newLabel);
            Map<ArcKey, Arc> postEdges = ((State)this.states.get((Object)sourceId)).postsetEdges;
            Map<ArcKey, Arc> preEdges = ((State)this.states.get((Object)targetId)).presetEdges;
            if (postEdges.containsKey(newKey)) {
                throw new ArcExistsException(this, newKey);
            }
            Arc a = postEdges.remove(oldKey);
            Arc a2 = preEdges.remove(oldKey);
            assert (a == a2);
            this.onArcRemovedUpdateByLabelCache(a);
            a.label = newEvent;
            this.removeEvent(oldEvent);
            this.onArcAddedUpdateByLabelCache(a);
            preEdges.put(newKey, a);
            postEdges.put(newKey, a);
            this.invokeListeners();
        } else {
            this.removeEvent(newEvent);
        }
    }

    private Event addEvent(String label) {
        InternalEvent event = this.alphabet.get(label);
        if (event == null) {
            event = new InternalEvent(label);
            this.alphabet.put(label, event);
            this.alphabetSet.add(event.getEvent());
        }
        event.increaseReferences();
        return event.getEvent();
    }

    private void removeEvent(Event event) {
        InternalEvent intEvent = this.alphabet.get(event.getLabel());
        if (intEvent.decreaseReferences()) {
            this.alphabet.remove(intEvent.getEvent().getLabel());
            this.alphabetSet.remove(intEvent.getEvent());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public State getNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        State s = (State)this.states.get(id);
        if (s == null) {
            throw new NoSuchNodeException(this, id);
        }
        return s;
    }

    @Override
    public Set<Arc> getEdges() {
        return new AbstractSet<Arc>(){

            @Override
            public int size() {
                return TransitionSystem.this.numArcs;
            }

            @Override
            public Iterator<Arc> iterator() {
                return new Iterator<Arc>(){
                    private Iterator<State> stateIter;
                    private Iterator<Arc> arcIter;
                    {
                        this.stateIter = TransitionSystem.this.states.values().iterator();
                        this.arcIter = EmptyIterator.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.arcIter.hasNext() && this.stateIter.hasNext()) {
                            this.arcIter = this.stateIter.next().postsetEdges.values().iterator();
                        }
                        return this.arcIter.hasNext();
                    }

                    @Override
                    public Arc next() {
                        this.hasNext();
                        return this.arcIter.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Set<State> getNodes() {
        return new CollectionToUnmodifiableSetAdapter<State>(this.states.values());
    }

    private Set<State> calcPresetNodes(String id) {
        Bag<State> pre = this.presetNodes.get(id);
        if (pre == null) {
            pre = new HashBag<State>();
            for (Arc a : this.getPresetEdges(id)) {
                pre.add((State)a.getSource());
            }
            this.presetNodes.put(id, pre);
        }
        return pre.uniqueSet();
    }

    private Set<State> calcPostsetNodes(String id) {
        Bag<State> post = this.postsetNodes.get(id);
        if (post == null) {
            post = new HashBag<State>();
            for (Arc a : this.getPostsetEdges(id)) {
                post.add((State)a.getTarget());
            }
            this.postsetNodes.put(id, post);
        }
        return post.uniqueSet();
    }

    @Override
    public Set<State> getPresetNodes(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.states.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(this.calcPresetNodes(id));
    }

    @Override
    public Set<State> getPostsetNodes(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.states.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(this.calcPostsetNodes(id));
    }

    @Override
    public Set<Arc> getPresetEdges(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        State state = (State)this.states.get(id);
        if (state == null) {
            throw new NoSuchNodeException(this, id);
        }
        return state.getPresetEdges();
    }

    @Override
    public Set<Arc> getPostsetEdges(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        State state = (State)this.states.get(id);
        if (state == null) {
            throw new NoSuchNodeException(this, id);
        }
        return state.getPostsetEdges();
    }

    @Override
    public Set<Arc> getPostsetEdges(State node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the ts '" + this.getName() + "'.");
        }
        return this.getPostsetEdges(node.getId());
    }

    @Override
    public Set<State> getPostsetNodes(State node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the ts '" + this.getName() + "'.");
        }
        return this.getPostsetNodes(node.getId());
    }

    @Override
    public Set<Arc> getPresetEdges(State node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the ts '" + this.getName() + "'.");
        }
        return this.getPresetEdges(node.getId());
    }

    @Override
    public Set<State> getPresetNodes(State node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the ts '" + this.getName() + "'.");
        }
        return this.getPresetNodes(node.getId());
    }

    public Set<State> getPresetNodesByLabel(State node, String label) {
        Set<Arc> arcs = this.getPresetEdgesByLabel(node, label);
        HashSet<State> states = new HashSet<State>();
        for (Arc arc : arcs) {
            states.add((State)arc.getSource());
        }
        return states;
    }

    public Set<Arc> getPresetEdgesByLabel(State node, String label) {
        return node.getPresetEdgesByLabel(label);
    }

    public Set<State> getPostsetNodesByLabel(State node, String label) {
        Set<Arc> arcs = this.getPostsetEdgesByLabel(node, label);
        HashSet<State> states = new HashSet<State>();
        for (Arc arc : arcs) {
            states.add((State)arc.getTarget());
        }
        return states;
    }

    public Set<Arc> getPostsetEdgesByLabel(State node, String label) {
        return node.getPostsetEdgesByLabel(label);
    }

    private void onArcAddedUpdateByLabelCache(Arc arc) {
        Map<String, Set<Arc>> postsetsByLabel = ((State)arc.getSource()).postsetEdgesByLabel;
        Set<Arc> postset = postsetsByLabel.get(arc.getLabel());
        if (postset == null) {
            postset = new HashSet<Arc>();
        }
        postset.add(arc);
        postsetsByLabel.put(arc.getLabel(), postset);
        Map<String, Set<Arc>> presetsByLabel = ((State)arc.getTarget()).presetEdgesByLabel;
        Set<Arc> preset = presetsByLabel.get(arc.getLabel());
        if (preset == null) {
            preset = new HashSet<Arc>();
        }
        preset.add(arc);
        presetsByLabel.put(arc.getLabel(), preset);
    }

    private void onArcRemovedUpdateByLabelCache(Arc arc) {
        Map<String, Set<Arc>> presetsByLabel;
        Set<Arc> preset;
        Map<String, Set<Arc>> postsetsByLabel = ((State)arc.getSource()).postsetEdgesByLabel;
        Set<Arc> postset = postsetsByLabel.get(arc.getLabel());
        if (postset != null) {
            postset.remove(arc);
        }
        if ((preset = (presetsByLabel = ((State)arc.getTarget()).presetEdgesByLabel).get(arc.getLabel())) != null) {
            preset.remove(arc);
        }
    }

    public boolean containsState(String sourceId) {
        return this.states.containsKey(sourceId);
    }

    private static class InternalEvent {
        private int references = 0;
        private final Event event;

        public InternalEvent(String label) {
            this.event = new Event(label);
        }

        public void increaseReferences() {
            ++this.references;
        }

        public boolean decreaseReferences() {
            --this.references;
            return this.references == 0;
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

