/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.ts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.CollectionToUnmodifiableSetAdapter;
import uniol.apt.adt.Node;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ArcKey;
import uniol.apt.adt.ts.TransitionSystem;

public class State
extends Node<TransitionSystem, Arc, State> {
    final Map<ArcKey, Arc> presetEdges = new HashMap<ArcKey, Arc>();
    final Map<ArcKey, Arc> postsetEdges = new HashMap<ArcKey, Arc>();
    final Map<String, Set<Arc>> postsetEdgesByLabel = new HashMap<String, Set<Arc>>();
    final Map<String, Set<Arc>> presetEdgesByLabel = new HashMap<String, Set<Arc>>();

    State(TransitionSystem ts, String id) {
        super(ts, id);
    }

    State(TransitionSystem ts, State s) {
        super(ts, s);
    }

    public Set<State> getPresetNodesByLabel(String label) {
        return ((TransitionSystem)this.graph).getPresetNodesByLabel(this, label);
    }

    public Set<Arc> getPresetEdgesByLabel(String label) {
        Set<Arc> result = this.presetEdgesByLabel.get(label);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<State> getPostsetNodesByLabel(String label) {
        return ((TransitionSystem)this.graph).getPostsetNodesByLabel(this, label);
    }

    public Set<Arc> getPostsetEdgesByLabel(String label) {
        Set<Arc> result = this.postsetEdgesByLabel.get(label);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<State> getPresetNodes() {
        return ((TransitionSystem)this.graph).getPresetNodes(this);
    }

    @Override
    public Set<State> getPostsetNodes() {
        return ((TransitionSystem)this.graph).getPostsetNodes(this);
    }

    @Override
    public Set<Arc> getPresetEdges() {
        return new CollectionToUnmodifiableSetAdapter<Arc>(this.presetEdges.values());
    }

    @Override
    public Set<Arc> getPostsetEdges() {
        return new CollectionToUnmodifiableSetAdapter<Arc>(this.postsetEdges.values());
    }
}

