/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.ts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.TreeBag;

public class ParikhVector {
    private final Bag<String> occurrenceBag = new TreeBag<String>();

    private ParikhVector(ParikhVector other) {
        this.occurrenceBag.addAll(other.occurrenceBag);
    }

    public ParikhVector(String ... sequence) {
        this(Arrays.asList(sequence));
    }

    public ParikhVector(List<String> sequence) {
        this.occurrenceBag.addAll(sequence);
    }

    public ParikhVector(Map<String, Integer> pv) {
        for (Map.Entry<String, Integer> entry : pv.entrySet()) {
            this.occurrenceBag.add(entry.getKey(), entry.getValue());
        }
    }

    public ParikhVector add(ParikhVector p2) {
        ParikhVector result = new ParikhVector(this);
        result.occurrenceBag.addAll(p2.occurrenceBag);
        return result;
    }

    public ParikhVector add(String ... sequence) {
        return this.add(Arrays.asList(sequence));
    }

    public ParikhVector add(List<String> sequence) {
        ParikhVector result = new ParikhVector(this);
        result.occurrenceBag.addAll(sequence);
        return result;
    }

    public ParikhVector tryRemove(String event, int n) {
        if (this.get(event) < n) {
            return null;
        }
        ParikhVector result = new ParikhVector(this);
        result.occurrenceBag.remove(event, n);
        return result;
    }

    public ParikhVector residual(ParikhVector other) {
        ParikhVector result = new ParikhVector(this);
        result.occurrenceBag.removeAll(other.occurrenceBag);
        return result;
    }

    public Comparison compare(ParikhVector pv2) {
        boolean greaterThan = this.occurrenceBag.containsAll(pv2.occurrenceBag);
        boolean lessThan = pv2.occurrenceBag.containsAll(this.occurrenceBag);
        if (!lessThan && greaterThan) {
            return Comparison.GREATER_THAN;
        }
        if (lessThan && !greaterThan) {
            return Comparison.LESS_THAN;
        }
        if (lessThan && greaterThan) {
            return Comparison.EQUAL;
        }
        return Comparison.INCOMPARABLE;
    }

    public boolean isUncomparableTo(ParikhVector pv2) {
        return !pv2.occurrenceBag.containsAll(this.occurrenceBag) && !this.occurrenceBag.containsAll(pv2.occurrenceBag);
    }

    public boolean sameOrMutuallyDisjoint(ParikhVector pv2) {
        return this.equals(pv2) || this.mutuallyDisjoint(pv2);
    }

    public boolean mutuallyDisjoint(ParikhVector pv2) {
        return Collections.disjoint(this.occurrenceBag, pv2.occurrenceBag);
    }

    public int get(String c) {
        return this.occurrenceBag.getCount(c);
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.occurrenceBag.uniqueSet());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParikhVector)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ParikhVector other = (ParikhVector)obj;
        return this.occurrenceBag.equals(other.occurrenceBag);
    }

    public int hashCode() {
        return this.occurrenceBag.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        boolean first = true;
        for (String label : this.occurrenceBag.uniqueSet()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(label).append('=').append(this.get(label));
            first = false;
        }
        builder.append("}");
        return builder.toString();
    }

    public static enum Comparison {
        LESS_THAN(-1),
        GREATER_THAN(1),
        EQUAL(0),
        INCOMPARABLE(0);

        private final int value;

        private Comparison(int value) {
            this.value = value;
        }

        public int asInt() {
            return this.value;
        }
    }
}

