/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.subgraph;

import java.util.Objects;
import java.util.Set;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.adt.extension.Extensible;
import uniol.apt.adt.subgraph.SubEdge;
import uniol.apt.adt.subgraph.SubGraph;

public class SubNode<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>>
extends Extensible
implements INode<SubGraph<G, E, N>, SubEdge<G, E, N>, SubNode<G, E, N>> {
    private final SubGraph<G, E, N> graph;
    private final N originalNode;

    SubNode(SubGraph<G, E, N> graph, N originalNode) {
        this.graph = graph;
        this.originalNode = originalNode;
    }

    public N getOriginalNode() {
        return this.originalNode;
    }

    @Override
    public String getId() {
        return this.originalNode.getId();
    }

    @Override
    public SubGraph<G, E, N> getGraph() {
        return this.graph;
    }

    @Override
    public Set<SubNode<G, E, N>> getPresetNodes() {
        return this.graph.getPresetNodes(this);
    }

    @Override
    public Set<SubNode<G, E, N>> getPostsetNodes() {
        return this.graph.getPostsetNodes(this);
    }

    @Override
    public Set<SubEdge<G, E, N>> getPresetEdges() {
        return this.graph.getPresetEdges(this);
    }

    @Override
    public Set<SubEdge<G, E, N>> getPostsetEdges() {
        return this.graph.getPostsetEdges(this);
    }

    public int hashCode() {
        return this.originalNode.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubNode) {
            SubNode other = (SubNode)o;
            return Objects.equals(this.graph, other.graph) && Objects.equals(this.originalNode, other.originalNode);
        }
        return false;
    }

    public String toString() {
        return this.originalNode.toString();
    }
}

