/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.subgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.IGraphListener;
import uniol.apt.adt.INode;
import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.extension.Extensible;
import uniol.apt.adt.subgraph.SubEdge;
import uniol.apt.adt.subgraph.SubNode;

public class SubGraph<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>>
extends Extensible
implements IGraph<SubGraph<G, E, N>, SubEdge<G, E, N>, SubNode<G, E, N>> {
    private final G originalGraph;
    private final Set<String> nodeIDs;

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SubGraph<G, E, N> getSubGraphByNodes(G graph, Collection<N> nodes) {
        HashSet<String> ids = new HashSet<String>();
        for (INode node : nodes) {
            if (!node.getGraph().equals(graph)) {
                throw new IllegalArgumentException("Node " + node + " does not belong to the graph " + graph);
            }
            ids.add(node.getId());
        }
        return new SubGraph<G, E, N>(graph, ids);
    }

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SubGraph<G, E, N> getSubGraphByNodeIDs(G graph, Collection<String> ids) {
        for (String id : ids) {
            if (graph.getNode(id) != null) continue;
            throw new IllegalArgumentException("No node with id " + id + " in graph " + graph);
        }
        return new SubGraph<G, E, N>(graph, new HashSet<String>(ids));
    }

    private SubGraph(G originalGraph, Set<String> nodeIDs) {
        this.originalGraph = originalGraph;
        this.nodeIDs = nodeIDs;
    }

    public SubGraph<G, E, N> getFlatSubGraphByNodes(Collection<SubNode<G, E, N>> nodes) {
        HashSet<String> ids = new HashSet<String>();
        for (SubNode<G, E, N> node : nodes) {
            if (!((SubGraph)node.getGraph()).equals(this)) {
                throw new IllegalArgumentException("Node " + node + " does not belong to the graph " + this);
            }
            ids.add(node.getId());
        }
        return new SubGraph<G, E, N>(this.originalGraph, ids);
    }

    public SubGraph<G, E, N> getFlatSubGraphByNodeIDs(Collection<String> ids) {
        HashSet<String> notExistentIDs = new HashSet<String>(ids);
        notExistentIDs.removeAll(this.nodeIDs);
        Iterator iterator = notExistentIDs.iterator();
        if (iterator.hasNext()) {
            String id = (String)iterator.next();
            throw new IllegalArgumentException("No node with id " + id + " in graph " + this);
        }
        return new SubGraph<G, E, N>(this.originalGraph, new HashSet<String>(ids));
    }

    public G getOriginalGraph() {
        return this.originalGraph;
    }

    public Set<String> getNodeIDs() {
        return Collections.unmodifiableSet(this.nodeIDs);
    }

    @Override
    public boolean addListener(IGraphListener<SubGraph<G, E, N>, SubEdge<G, E, N>, SubNode<G, E, N>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeListener(IGraphListener<SubGraph<G, E, N>, SubEdge<G, E, N>, SubNode<G, E, N>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.originalGraph.getName();
    }

    public SubNode<G, E, N> getNode(N node) {
        this.checkNode(node);
        return new SubNode(this, node);
    }

    @Override
    public SubNode<G, E, N> getNode(String id) {
        this.checkNode(id);
        Object node = this.originalGraph.getNode(id);
        if (node == null) {
            return null;
        }
        return new SubNode(this, node);
    }

    @Override
    public Set<SubEdge<G, E, N>> getEdges() {
        return this.filterEdges(this.originalGraph.getEdges());
    }

    @Override
    public Set<SubNode<G, E, N>> getNodes() {
        return this.filterNodes(this.originalGraph.getNodes());
    }

    @Override
    public Set<SubNode<G, E, N>> getPresetNodes(String id) {
        this.checkNode(id);
        return this.filterNodes(this.originalGraph.getPresetNodes((String)id));
    }

    @Override
    public Set<SubNode<G, E, N>> getPresetNodes(SubNode<G, E, N> node) {
        this.checkNode(node);
        return this.filterNodes(this.originalGraph.getPresetNodes(node.getOriginalNode()));
    }

    @Override
    public Set<SubNode<G, E, N>> getPostsetNodes(String id) {
        this.checkNode(id);
        return this.filterNodes(this.originalGraph.getPostsetNodes((String)id));
    }

    @Override
    public Set<SubNode<G, E, N>> getPostsetNodes(SubNode<G, E, N> node) {
        this.checkNode(node);
        return this.filterNodes(this.originalGraph.getPostsetNodes(node.getOriginalNode()));
    }

    @Override
    public Set<SubEdge<G, E, N>> getPresetEdges(String id) {
        this.checkNode(id);
        return this.filterEdges(this.originalGraph.getPresetEdges((String)id));
    }

    @Override
    public Set<SubEdge<G, E, N>> getPresetEdges(SubNode<G, E, N> node) {
        this.checkNode(node);
        return this.filterEdges(this.originalGraph.getPresetEdges(node.getOriginalNode()));
    }

    @Override
    public Set<SubEdge<G, E, N>> getPostsetEdges(String id) {
        this.checkNode(id);
        return this.filterEdges(this.originalGraph.getPostsetEdges((String)id));
    }

    @Override
    public Set<SubEdge<G, E, N>> getPostsetEdges(SubNode<G, E, N> node) {
        this.checkNode(node);
        return this.filterEdges(this.originalGraph.getPostsetEdges(node.getOriginalNode()));
    }

    public int hashCode() {
        return this.originalGraph.hashCode() + this.nodeIDs.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubGraph) {
            SubGraph other = (SubGraph)o;
            return Objects.equals(this.originalGraph, other.originalGraph) && Objects.equals(this.nodeIDs, other.nodeIDs);
        }
        return false;
    }

    public String toString() {
        return String.format("SubGraph of '%s' with nodes %s", this.originalGraph, this.nodeIDs);
    }

    private Set<SubNode<G, E, N>> filterNodes(Set<N> nodes) {
        HashSet result = new HashSet();
        for (INode node : nodes) {
            if (!this.nodeIDs.contains(node.getId())) continue;
            result.add(new SubNode(this, node));
        }
        return result;
    }

    private Set<SubEdge<G, E, N>> filterEdges(Set<E> edges) {
        HashSet result = new HashSet();
        for (IEdge edge : edges) {
            if (!this.nodeIDs.contains(edge.getSource().getId()) || !this.nodeIDs.contains(edge.getTarget().getId())) continue;
            result.add(new SubEdge(this, edge));
        }
        return result;
    }

    private void checkNode(String id) {
        if (!this.nodeIDs.contains(id)) {
            throw new NoSuchNodeException(this, id);
        }
    }

    private void checkNode(N node) {
        if (!node.getGraph().equals(this.originalGraph)) {
            throw new NoSuchNodeException(this, node.getId());
        }
        this.checkNode(node.getId());
    }

    private void checkNode(SubNode<G, E, N> node) {
        if (!((SubGraph)node.getGraph()).equals(this)) {
            throw new NoSuchNodeException(this, node.getId());
        }
    }
}

