/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.subgraph;

import java.util.Objects;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.adt.extension.Extensible;
import uniol.apt.adt.subgraph.SubGraph;
import uniol.apt.adt.subgraph.SubNode;

public class SubEdge<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>>
extends Extensible
implements IEdge<SubGraph<G, E, N>, SubEdge<G, E, N>, SubNode<G, E, N>> {
    private final SubGraph<G, E, N> graph;
    private final E originalEdge;

    SubEdge(SubGraph<G, E, N> graph, E originalEdge) {
        this.graph = graph;
        this.originalEdge = originalEdge;
    }

    public E getOriginalEdge() {
        return this.originalEdge;
    }

    @Override
    public SubGraph<G, E, N> getGraph() {
        return this.graph;
    }

    @Override
    public SubNode<G, E, N> getSource() {
        return this.graph.getNode(this.originalEdge.getSource().getId());
    }

    @Override
    public SubNode<G, E, N> getTarget() {
        return this.graph.getNode(this.originalEdge.getTarget().getId());
    }

    public int hashCode() {
        return this.originalEdge.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubEdge) {
            SubEdge other = (SubEdge)o;
            return Objects.equals(this.graph, other.graph) && Objects.equals(this.originalEdge, other.originalEdge);
        }
        return false;
    }

    public String toString() {
        return this.originalEdge.toString();
    }
}

