/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.pn;

import java.util.Objects;

public class Token
implements Comparable<Token> {
    private final long v;
    public static final Token OMEGA = new Token(-1L, false);
    public static final Token ZERO = new Token(0L);
    private static Token[] tokenCache = new Token[256];

    public static Token valueOf(long v) {
        if (v >= 0L && v < (long)tokenCache.length) {
            return tokenCache[(int)v];
        }
        return new Token(v);
    }

    private Token(long v, boolean checkValue) {
        if (checkValue && v < 0L) {
            throw new IllegalArgumentException("v<0");
        }
        this.v = v;
    }

    @Deprecated
    public Token(long v) {
        this(v, true);
    }

    Token add(Token t) {
        if (t == null) {
            throw new IllegalArgumentException("v == null");
        }
        if (this.isOmega()) {
            return this;
        }
        if (t.isOmega()) {
            return t;
        }
        assert (t.v >= 0L);
        return this.add(t.v);
    }

    Token add(long t) {
        if (this.isOmega()) {
            return this;
        }
        if (this.v + t < 0L) {
            throw new IllegalArgumentException("this.v + v < 0");
        }
        return Token.valueOf(this.v + t);
    }

    public long getValue() {
        return this.v;
    }

    public boolean isOmega() {
        return this.equals(OMEGA);
    }

    public int hashCode() {
        return (int)this.v;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return Objects.equals(this.v, other.v);
    }

    public String toString() {
        if (this.isOmega()) {
            return "OMEGA";
        }
        return Long.toString(this.v);
    }

    @Override
    public int compareTo(Token o) {
        if (this.isOmega()) {
            return o.isOmega() ? 0 : 1;
        }
        if (o.isOmega()) {
            return -1;
        }
        return this.v < o.v ? -1 : (this.v > o.v ? 1 : 0);
    }

    static {
        Token.tokenCache[0] = ZERO;
        for (int i = 1; i < tokenCache.length; ++i) {
            Token.tokenCache[i] = new Token(i);
        }
    }
}

