/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.pn;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.iterators.EmptyIterator;
import uniol.apt.adt.AbstractGraph;
import uniol.apt.adt.CollectionToUnmodifiableSetAdapter;
import uniol.apt.adt.EdgeKey;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.SoftMap;
import uniol.apt.adt.exception.FlowExistsException;
import uniol.apt.adt.exception.IllegalFlowException;
import uniol.apt.adt.exception.NoSuchEdgeException;
import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.exception.NodeExistsException;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.exception.TransitionFireException;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.adt.pn.Transition;

public class PetriNet
extends AbstractGraph<PetriNet, Flow, Node>
implements IGraph<PetriNet, Flow, Node> {
    private String name;
    private long nextPlaceId = 0L;
    private long nextTransitionId = 0L;
    private final SortedMap<String, Node> nodes = new TreeMap<String, Node>();
    private final SortedMap<String, Place> places = new TreeMap<String, Place>();
    private List<Place> placesList = Collections.emptyList();
    private final SortedMap<String, Transition> transitions = new TreeMap<String, Transition>();
    private final Map<String, Set<Node>> presetNodes = new SoftMap<String, Set<Node>>();
    private final Map<String, Set<Node>> postsetNodes = new SoftMap<String, Set<Node>>();
    private final Map<String, Map<EdgeKey, Flow>> presetEdges = new HashMap<String, Map<EdgeKey, Flow>>();
    private final Map<String, Map<EdgeKey, Flow>> postsetEdges = new HashMap<String, Map<EdgeKey, Flow>>();
    private int numFlows = 0;
    private Marking initialMarking = new Marking(this);
    private final Set<Marking> finalMarkings = new HashSet<Marking>();

    public PetriNet() {
        this("");
    }

    public PetriNet(String name) {
        this.name = name;
    }

    public PetriNet(PetriNet pn) {
        this.name = pn.name;
        this.nextPlaceId = pn.nextPlaceId;
        this.nextTransitionId = pn.nextTransitionId;
        for (String string : pn.places.keySet()) {
            this.addPlace(string, new Place(this, (Place)pn.places.get(string)));
        }
        for (String string : pn.transitions.keySet()) {
            this.addTransition(string, new Transition(this, (Transition)pn.transitions.get(string)));
        }
        for (Map map : pn.postsetEdges.values()) {
            for (Map.Entry entry : map.entrySet()) {
                this.addFlow((EdgeKey)entry.getKey(), new Flow(this, (Flow)entry.getValue()));
            }
        }
        for (Marking marking : pn.finalMarkings) {
            this.finalMarkings.add(new Marking(this, marking));
        }
        this.initialMarking = new Marking(this, pn.initialMarking);
        this.copyExtensions(pn);
    }

    public Flow createFlow(String sourceId, String targetId) {
        return this.createFlow(sourceId, targetId, 1);
    }

    private Flow addFlow(EdgeKey key, Flow f) {
        Set<Node> postNodes;
        String targetId = key.getTargetId();
        String sourceId = key.getSourceId();
        this.presetEdges.get(targetId).put(key, f);
        this.postsetEdges.get(sourceId).put(key, f);
        ++this.numFlows;
        Set<Node> preNodes = this.presetNodes.get(targetId);
        if (preNodes != null) {
            preNodes.add(this.getNode(sourceId));
        }
        if ((postNodes = this.postsetNodes.get(sourceId)) != null) {
            postNodes.add(this.getNode(targetId));
        }
        this.invokeListeners();
        return f;
    }

    public Flow createFlow(String sourceId, String targetId, int weight) {
        boolean hasTransition;
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        if (weight < 0) {
            throw new IllegalArgumentException("weight < 0");
        }
        EdgeKey key = this.createEdgeKey(sourceId, targetId);
        if (this.postsetEdges.get(sourceId).containsKey(key)) {
            throw new FlowExistsException(this, key);
        }
        boolean hasPlace = this.places.containsKey(sourceId) || this.places.containsKey(targetId);
        boolean bl = hasTransition = this.transitions.containsKey(sourceId) || this.transitions.containsKey(targetId);
        if (!hasPlace || !hasTransition) {
            throw new IllegalFlowException(this, key);
        }
        Flow f = new Flow(this, this.getNode(sourceId), this.getNode(targetId), weight);
        if (weight > 0) {
            this.addFlow(key, f);
        }
        return f;
    }

    public Flow createFlow(Node source, Node target, int weight) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        return this.createFlow(source.getId(), target.getId(), weight);
    }

    public Flow createFlow(Node source, Node target) {
        return this.createFlow(source, target, 1);
    }

    public Flow createFlow(Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException("flow == null");
        }
        Flow f = this.createFlow(flow.getSourceId(), flow.getTargetId(), flow.getWeight());
        f.copyExtensions(flow);
        return f;
    }

    private Place addPlace(String id, Place p) {
        this.places.put(id, p);
        this.nodes.put(id, p);
        this.placesList = new ArrayList<Place>(this.placesList);
        this.placesList.add(p);
        this.presetNodes.put(id, new HashSet());
        this.postsetNodes.put(id, new HashSet());
        this.presetEdges.put(id, new HashMap());
        this.postsetEdges.put(id, new HashMap());
        this.invokeListeners();
        return p;
    }

    public Place createPlace(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            return this.addPlace(id, new Place(this, id));
        }
        throw new NodeExistsException(this, id);
    }

    public Place createPlace() {
        while (this.nodes.containsKey("p" + this.nextPlaceId)) {
            ++this.nextPlaceId;
        }
        Place p = this.createPlace("p" + this.nextPlaceId);
        ++this.nextPlaceId;
        return p;
    }

    public Place createPlace(Place p) {
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        Place place = this.createPlace(p.getId());
        place.copyExtensions(p);
        return place;
    }

    public Place[] createPlaces(Place ... placeList) {
        if (placeList == null) {
            throw new IllegalArgumentException("places == null");
        }
        Place[] out = new Place[placeList.length];
        for (int i = 0; i < placeList.length; ++i) {
            out[i] = this.createPlace(placeList[i]);
        }
        return out;
    }

    public Place[] createPlaces(String ... idList) {
        if (idList == null) {
            throw new IllegalArgumentException("places == null");
        }
        Place[] out = new Place[idList.length];
        for (int i = 0; i < idList.length; ++i) {
            out[i] = this.createPlace(idList[i]);
        }
        return out;
    }

    public Place[] createPlaces(int count) {
        Place[] out = new Place[count];
        for (int i = 0; i < count; ++i) {
            out[i] = this.createPlace();
        }
        return out;
    }

    public Transition createTransition(String id) {
        return this.createTransition(id, id);
    }

    private Transition addTransition(String id, Transition t) {
        this.transitions.put(id, t);
        this.nodes.put(id, t);
        this.presetNodes.put(id, new HashSet());
        this.postsetNodes.put(id, new HashSet());
        this.presetEdges.put(id, new HashMap());
        this.postsetEdges.put(id, new HashMap());
        this.invokeListeners();
        return t;
    }

    public Transition createTransition(String id, String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            Transition t = new Transition(this, id);
            t.label = label;
            return this.addTransition(id, t);
        }
        throw new NodeExistsException(this, id);
    }

    public Transition createTransition() {
        while (this.nodes.containsKey("t" + this.nextTransitionId)) {
            ++this.nextTransitionId;
        }
        Transition t = this.createTransition("t" + this.nextTransitionId);
        ++this.nextTransitionId;
        return t;
    }

    public Transition createTransition(Transition t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        Transition trans = this.createTransition(t.getId(), t.getLabel());
        trans.copyExtensions(t);
        return trans;
    }

    public Transition[] createTransitions(Transition ... transitionList) {
        if (transitionList == null) {
            throw new IllegalArgumentException("transitions == null");
        }
        Transition[] out = new Transition[transitionList.length];
        for (int i = 0; i < transitionList.length; ++i) {
            out[i] = this.createTransition(transitionList[i]);
        }
        return out;
    }

    public Transition[] createTransitions(String ... idList) {
        if (idList == null) {
            throw new IllegalArgumentException("transitions == null");
        }
        Transition[] out = new Transition[idList.length];
        for (int i = 0; i < idList.length; ++i) {
            out[i] = this.createTransition(idList[i]);
        }
        return out;
    }

    public Transition[] createTransitions(int count) {
        Transition[] out = new Transition[count];
        for (int i = 0; i < count; ++i) {
            out[i] = this.createTransition();
        }
        return out;
    }

    public void removeFlow(String sourceId, String targetId) {
        Set<Node> postNodes;
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        EdgeKey key = this.createEdgeKey(sourceId, targetId);
        Flow f = this.postsetEdges.get(sourceId).get(key);
        if (f == null) {
            throw new NoSuchEdgeException(this, sourceId, targetId);
        }
        Set<Node> preNodes = this.presetNodes.get(targetId);
        if (preNodes != null) {
            preNodes.remove(this.nodes.get(sourceId));
        }
        if ((postNodes = this.postsetNodes.get(sourceId)) != null) {
            postNodes.remove(this.nodes.get(targetId));
        }
        Flow old = this.presetEdges.get(targetId).remove(key);
        assert (old == f);
        old = this.postsetEdges.get(sourceId).remove(key);
        assert (old == f);
        --this.numFlows;
        this.invokeListeners();
    }

    public void removeFlow(Node source, Node target) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        this.removeFlow(source.getId(), target.getId());
    }

    public void removeFlow(Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException("flow == null");
        }
        this.removeFlow(flow.getSourceId(), flow.getTargetId());
    }

    public void removeNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (this.transitions.containsKey(id)) {
            this.removeTransition(id);
        } else if (this.places.containsKey(id)) {
            this.removePlace(id);
        } else {
            throw new NoSuchNodeException(this, id);
        }
    }

    public void removeNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.removeNode(node.getId());
    }

    private void rmNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        Node n = (Node)this.nodes.get(id);
        if (n == null) {
            throw new NoSuchNodeException(this, id);
        }
        HashSet<Flow> pe = new HashSet<Flow>(this.getPresetEdges(id));
        for (Flow f : pe) {
            this.removeFlow(f);
        }
        pe = new HashSet<Flow>(this.getPostsetEdges(id));
        for (Flow f : pe) {
            this.removeFlow(f);
        }
        this.presetNodes.remove(id);
        this.postsetNodes.remove(id);
        this.presetEdges.remove(id);
        this.postsetEdges.remove(id);
        this.nodes.remove(id);
    }

    public void removePlace(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.places.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        this.placesList = new ArrayList<Place>(this.placesList);
        this.placesList.remove(this.places.get(id));
        this.rmNode(id);
        this.places.remove(id);
        this.invokeListeners();
    }

    public void removePlace(Place place) {
        if (place == null) {
            throw new IllegalArgumentException("place == null");
        }
        this.removePlace(place.getId());
    }

    public void removeTransition(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.transitions.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        this.rmNode(id);
        this.transitions.remove(id);
        this.invokeListeners();
    }

    public void removeTransition(Transition trans) {
        if (trans == null) {
            throw new IllegalArgumentException("trans == null");
        }
        this.removeTransition(trans.getId());
    }

    public Flow getFlow(String sourceId, String targetId) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        EdgeKey key = this.createEdgeKey(sourceId, targetId);
        Flow f = this.postsetEdges.get(sourceId).get(key);
        if (f == null) {
            throw new NoSuchEdgeException(this, sourceId, targetId);
        }
        return f;
    }

    public Flow getFlow(Node source, Node target) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        return this.getFlow(source.getId(), target.getId());
    }

    public Place getPlace(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        Place p = (Place)this.places.get(id);
        if (p == null) {
            throw new NoSuchNodeException(this, id);
        }
        return p;
    }

    public Transition getTransition(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        Transition t = (Transition)this.transitions.get(id);
        if (t == null) {
            throw new NoSuchNodeException(this, id);
        }
        return t;
    }

    public boolean containsNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        return this.nodes.containsKey(id);
    }

    public boolean containsNode(Node n) {
        if (n == null) {
            throw new IllegalArgumentException("id == null");
        }
        return this.containsNode(n.getId());
    }

    public boolean containsPlace(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        return this.places.containsKey(id);
    }

    public boolean containsPlace(Place p) {
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        return this.containsPlace(p.getId());
    }

    public boolean containsTransition(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        return this.transitions.containsKey(id);
    }

    public boolean containsTransition(Transition t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        return this.containsTransition(t.getId());
    }

    public Set<Place> getPlaces() {
        return new CollectionToUnmodifiableSetAdapter<Place>(this.places.values());
    }

    public Set<Transition> getTransitions() {
        return new CollectionToUnmodifiableSetAdapter<Transition>(this.transitions.values());
    }

    public void setInitialMarking(Marking m) {
        if (m.getNet() != this) {
            throw new IllegalArgumentException("Marking do not belong to the net " + this.getName());
        }
        this.initialMarking = m;
        this.invokeListeners();
    }

    public Marking getInitialMarking() {
        return new Marking(this.initialMarking);
    }

    @Deprecated
    public Marking getInitialMarkingCopy() {
        return this.getInitialMarking();
    }

    public boolean addFinalMarking(Marking m) {
        if (m.getNet() != this) {
            throw new IllegalArgumentException("Marking do not belong to the net " + this.getName());
        }
        return this.finalMarkings.add(m);
    }

    public Set<Marking> getFinalMarkings() {
        return Collections.unmodifiableSet(this.finalMarkings);
    }

    List<Place> getPlacesList() {
        return this.placesList;
    }

    private EdgeKey createEdgeKey(String sourceId, String targetId) {
        Node s = this.getNode(sourceId);
        if (s == null) {
            throw new NoSuchNodeException(this, sourceId);
        }
        Node t = this.getNode(targetId);
        if (t == null) {
            throw new NoSuchNodeException(this, targetId);
        }
        return new EdgeKey(sourceId, targetId);
    }

    Token getInitialToken(String id) {
        return this.initialMarking.getToken(id);
    }

    void setInitialToken(String id, Token t) {
        this.initialMarking = this.initialMarking.setTokenCount(id, t);
        this.invokeListeners();
    }

    void setFlowWeight(String sourceId, String targetId, int w) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        EdgeKey key = this.createEdgeKey(sourceId, targetId);
        Flow f = this.postsetEdges.get(sourceId).get(key);
        if (f == null) {
            throw new NoSuchEdgeException(this, sourceId, targetId);
        }
        if (w < 1) {
            this.removeFlow(sourceId, targetId);
        } else {
            f.weight = w;
            this.invokeListeners();
        }
    }

    Place getFlowPlace(String sourceId, String targetId) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        Place p = (Place)this.places.get(sourceId);
        if (p != null) {
            return p;
        }
        if (this.places.containsKey(targetId)) {
            return (Place)this.places.get(targetId);
        }
        throw new NoSuchNodeException(this, sourceId);
    }

    Transition getFlowTransition(String sourceId, String targetId) {
        if (sourceId == null) {
            throw new IllegalArgumentException("sourceId == null");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId == null");
        }
        Transition t = (Transition)this.transitions.get(sourceId);
        if (t != null) {
            return t;
        }
        if (this.transitions.containsKey(targetId)) {
            return (Transition)this.transitions.get(targetId);
        }
        throw new NoSuchNodeException(this, sourceId);
    }

    void setTransitionLabel(String id, String label) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        Transition t = (Transition)this.transitions.get(id);
        if (t == null) {
            throw new NoSuchNodeException(this, id);
        }
        t.label = label;
        this.invokeListeners();
    }

    boolean getTransitionIsFireable(String id, Marking m) {
        for (Flow f : this.getPresetEdges(id)) {
            if (m.getToken(f.getPlace()).compareTo(Token.valueOf(f.getWeight())) >= 0) continue;
            return false;
        }
        return true;
    }

    Marking fireTransition(String id, Marking m) {
        if (this.getTransitionIsFireable(id, m)) {
            for (Flow f : this.getPresetEdges(id)) {
                m = m.addTokenCount(f.getPlace(), -f.getWeight());
            }
            for (Flow f : this.getPostsetEdges(id)) {
                m = m.addTokenCount(f.getPlace(), f.getWeight());
            }
            return m;
        }
        throw new TransitionFireException("transition '" + id + "' is not fireable in marking '" + m.toString() + "'.");
    }

    public int[][] getIncidenceMatrix() {
        int[][] incidenceMatrix = new int[this.places.size()][this.transitions.size()];
        for (Flow a : this.getEdges()) {
            Transition t = a.getTransition();
            int row = this.indexOfPlace(a.getPlace());
            int col = this.indexOfTransition(t);
            if (row < 0 || col < 0) continue;
            int[] nArray = incidenceMatrix[row];
            int n = col;
            nArray[n] = nArray[n] + (a.getSourceId().equals(t.getId()) ? a.getWeight() : -a.getWeight());
        }
        return incidenceMatrix;
    }

    private int indexOfPlace(Place p) {
        Iterator<Place> iter = this.places.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (Objects.equals(iter.next(), p)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfTransition(Transition t) {
        Iterator<Transition> iter = this.transitions.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (Objects.equals(iter.next(), t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        Node node = (Node)this.nodes.get(id);
        if (node != null) {
            return node;
        }
        throw new NoSuchNodeException(this, id);
    }

    @Override
    public Set<Flow> getEdges() {
        return new AbstractSet<Flow>(){

            @Override
            public int size() {
                return PetriNet.this.numFlows;
            }

            @Override
            public Iterator<Flow> iterator() {
                return new Iterator<Flow>(){
                    private Iterator<Map<EdgeKey, Flow>> postsetIter;
                    private Iterator<Flow> flowIter;
                    {
                        this.postsetIter = PetriNet.this.postsetEdges.values().iterator();
                        this.flowIter = EmptyIterator.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.flowIter.hasNext() && this.postsetIter.hasNext()) {
                            this.flowIter = this.postsetIter.next().values().iterator();
                        }
                        return this.flowIter.hasNext();
                    }

                    @Override
                    public Flow next() {
                        this.hasNext();
                        return this.flowIter.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Set<Node> getNodes() {
        return new CollectionToUnmodifiableSetAdapter<Node>(this.nodes.values());
    }

    private Set<Node> calcPresetNodes(String id) {
        Set<Node> pre = this.presetNodes.get(id);
        if (pre == null) {
            pre = new HashSet<Node>();
            for (Flow a : this.getPresetEdges(id)) {
                pre.add((Node)a.getSource());
            }
            this.presetNodes.put(id, pre);
        }
        return pre;
    }

    private Set<Node> calcPostsetNodes(String id) {
        Set<Node> post = this.postsetNodes.get(id);
        if (post == null) {
            post = new HashSet<Node>();
            for (Flow a : this.getPostsetEdges(id)) {
                post.add((Node)a.getTarget());
            }
            this.postsetNodes.put(id, post);
        }
        return post;
    }

    @Override
    public Set<Node> getPresetNodes(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(this.calcPresetNodes(id));
    }

    @Override
    public Set<Node> getPostsetNodes(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(this.calcPostsetNodes(id));
    }

    @Override
    public Set<Flow> getPresetEdges(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(new LinkedHashSet<Flow>(this.presetEdges.get(id).values()));
    }

    @Override
    public Set<Flow> getPostsetEdges(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (!this.nodes.containsKey(id)) {
            throw new NoSuchNodeException(this, id);
        }
        return Collections.unmodifiableSet(new LinkedHashSet<Flow>(this.postsetEdges.get(id).values()));
    }

    @Override
    public Set<Flow> getPostsetEdges(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        return this.getPostsetEdges(node.getId());
    }

    @Override
    public Set<Node> getPostsetNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        return this.getPostsetNodes(node.getId());
    }

    @Override
    public Set<Flow> getPresetEdges(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        return this.getPresetEdges(node.getId());
    }

    @Override
    public Set<Node> getPresetNodes(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (this != node.getGraph()) {
            throw new StructureException("node'" + node.getId() + "' does not belong to the net '" + this.getName() + "'.");
        }
        return this.getPresetNodes(node.getId());
    }
}

