/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.pn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.adt.pn.Transition;

public class Marking {
    private final PetriNet net;
    private List<Place> placesList;
    private List<Token> tokenList = new ArrayList<Token>();

    public Marking(PetriNet net) {
        this.net = net;
        this.placesList = net.getPlacesList();
        for (Place place : this.placesList) {
            this.tokenList.add(Token.ZERO);
        }
    }

    public Marking(Marking m) {
        this.net = m.net;
        this.placesList = m.placesList;
        this.tokenList = new ArrayList<Token>(m.tokenList);
    }

    public Marking(PetriNet net, Marking m) {
        this.net = net;
        if (this.net == m.net) {
            this.placesList = m.placesList;
            this.tokenList = new ArrayList<Token>(m.tokenList);
        } else {
            m.ensureConsistency();
            this.placesList = this.net.getPlacesList();
            this.tokenList = new ArrayList<Token>(Collections.nCopies(this.placesList.size(), Token.ZERO));
            for (int idx = 0; idx < m.placesList.size(); ++idx) {
                int ownIdx = this.placesList.indexOf(net.getPlace(m.placesList.get(idx).getId()));
                this.tokenList.set(ownIdx, m.tokenList.get(idx));
            }
        }
    }

    public Marking(PetriNet net, Map<String, Integer> m) {
        this.net = net;
        this.placesList = net.getPlacesList();
        this.tokenList = new ArrayList<Token>(Collections.nCopies(this.placesList.size(), Token.ZERO));
        for (Map.Entry<String, Integer> entry : m.entrySet()) {
            int idx = this.placesList.indexOf(this.net.getPlace(entry.getKey()));
            if (idx == -1) {
                throw new StructureException("place '" + entry.getKey() + "' does not belong to net '" + this.net.getName() + "'.");
            }
            this.tokenList.set(idx, Token.valueOf(entry.getValue().intValue()));
        }
        this.ensureConsistency();
    }

    public Marking(PetriNet net, int ... orderedTokenCounts) {
        this.net = net;
        this.placesList = this.net.getPlacesList();
        if (orderedTokenCounts.length != this.placesList.size()) {
            throw new StructureException("Count of tokencounts does not match the count ofplaces in graph '" + this.net.getName() + "'.");
        }
        for (int i = 0; i < orderedTokenCounts.length; ++i) {
            this.tokenList.add(Token.valueOf(orderedTokenCounts[i]));
        }
    }

    public PetriNet getNet() {
        return this.net;
    }

    public Marking fireTransitions(Transition ... t) {
        this.ensureConsistency();
        Marking result = this;
        for (int i = 0; i < t.length; ++i) {
            result = this.net.fireTransition(t[i].getId(), result);
        }
        return result;
    }

    @Deprecated
    public Marking fire(Transition ... t) {
        this.ensureConsistency();
        Marking result = this.fireTransitions(t);
        this.placesList = result.placesList;
        this.tokenList = result.tokenList;
        return this;
    }

    public Marking setTokenCount(String placeId, Token m) {
        return this.setTokenCount(this.net.getPlace(placeId), m);
    }

    @Deprecated
    public void setToken(String placeId, Token m) {
        this.setToken(this.net.getPlace(placeId), m);
    }

    public Marking setTokenCount(String placeId, int m) {
        return this.setTokenCount(this.net.getPlace(placeId), m);
    }

    @Deprecated
    public void setToken(String placeId, int m) {
        this.setToken(this.net.getPlace(placeId), m);
    }

    public Marking setTokenCount(Place p, Token m) {
        assert (p != null && m != null);
        this.ensureConsistency();
        if (this.net != p.getGraph() || !this.placesList.contains(p)) {
            throw new StructureException("place '" + p.getId() + "' does not belong to net '" + this.net.getName() + "'.");
        }
        Marking result = new Marking(this);
        int idx = result.placesList.indexOf(p);
        result.tokenList.set(idx, m);
        return result;
    }

    @Deprecated
    public void setToken(Place p, Token m) {
        assert (p != null && m != null);
        this.ensureConsistency();
        if (this.net != p.getGraph() || !this.placesList.contains(p)) {
            throw new StructureException("place '" + p.getId() + "' does not belong to net '" + this.net.getName() + "'.");
        }
        int idx = this.placesList.indexOf(p);
        this.tokenList.set(idx, m);
    }

    public Marking setTokenCount(Place p, int m) {
        return this.setTokenCount(p, Token.valueOf(m));
    }

    @Deprecated
    public void setToken(Place p, int m) {
        this.setToken(p, Token.valueOf(m));
    }

    public Marking addTokenCount(String id, Token m) {
        assert (id != null && m != null);
        return this.addTokenCount(this.net.getPlace(id), m);
    }

    @Deprecated
    public void addToken(String id, Token m) {
        assert (id != null && m != null);
        this.addToken(this.net.getPlace(id), m);
    }

    public Marking addTokenCount(Place p, Token m) {
        assert (p != null && m != null);
        Token val = this.getToken(p);
        Marking result = new Marking(this);
        int idx = result.placesList.indexOf(p);
        result.tokenList.set(idx, val.add(m));
        return result;
    }

    @Deprecated
    public void addToken(Place p, Token m) {
        assert (p != null && m != null);
        this.ensureConsistency();
        Token val = this.getToken(p);
        int idx = this.placesList.indexOf(p);
        this.tokenList.set(idx, val.add(m));
    }

    public Marking addTokenCount(String id, int m) {
        assert (id != null);
        return this.addTokenCount(this.net.getPlace(id), m);
    }

    @Deprecated
    public void addToken(String id, int m) {
        assert (id != null);
        this.addToken(this.net.getPlace(id), m);
    }

    public Marking addTokenCount(Place p, int m) {
        assert (p != null);
        this.ensureConsistency();
        Token val = this.getToken(p);
        Marking result = new Marking(this);
        int idx = result.placesList.indexOf(p);
        result.tokenList.set(idx, val.add(m));
        return result;
    }

    @Deprecated
    public void addToken(Place p, int m) {
        assert (p != null);
        this.ensureConsistency();
        Token val = this.getToken(p);
        int idx = this.placesList.indexOf(p);
        this.tokenList.set(idx, val.add(m));
    }

    public Token getToken(String id) {
        assert (id != null);
        return this.getToken(this.net.getPlace(id));
    }

    public Token getToken(Place p) {
        assert (p != null);
        if (this.net != p.getGraph()) {
            throw new StructureException("place '" + p.getId() + "' does not belong to net '" + this.net.getName() + "'.");
        }
        this.ensureConsistency();
        int idx = this.placesList.indexOf(p);
        if (idx == -1) {
            throw new NoSuchNodeException(this.net, p.getId());
        }
        return this.tokenList.get(idx);
    }

    public Collection<Token> values() {
        this.ensureConsistency();
        return Collections.unmodifiableList(this.tokenList);
    }

    final void ensureConsistency() {
        if (this.placesList != this.net.getPlacesList()) {
            List<Place> oldPlacesList = this.placesList;
            List<Token> oldTokenList = this.tokenList;
            this.placesList = this.net.getPlacesList();
            this.tokenList = new ArrayList<Token>(this.placesList.size());
            for (Place place : this.placesList) {
                int idx = oldPlacesList.indexOf(place);
                if (idx == -1) {
                    this.tokenList.add(Token.ZERO);
                    continue;
                }
                this.tokenList.add(oldTokenList.get(idx));
            }
        }
    }

    public Marking cover(Marking o) {
        this.ensureConsistency();
        o.ensureConsistency();
        assert (this.placesList == o.placesList);
        HashSet<Integer> covered = new HashSet<Integer>();
        for (int idx = 0; idx < this.placesList.size(); ++idx) {
            Token other;
            Token own = this.tokenList.get(idx);
            int comp = own.compareTo(other = o.tokenList.get(idx));
            if (comp < 0) {
                return null;
            }
            if (comp <= 0 || own.isOmega()) continue;
            covered.add(idx);
        }
        if (covered.isEmpty()) {
            return null;
        }
        Marking result = new Marking(this);
        Iterator iterator = covered.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            result.tokenList.set(idx, Token.OMEGA);
        }
        return result;
    }

    @Deprecated
    public boolean covers(Marking o) {
        this.ensureConsistency();
        o.ensureConsistency();
        assert (this.placesList == o.placesList);
        HashSet<Integer> covered = new HashSet<Integer>();
        for (int idx = 0; idx < this.placesList.size(); ++idx) {
            Token other;
            Token own = this.tokenList.get(idx);
            int comp = own.compareTo(other = o.tokenList.get(idx));
            if (comp < 0) {
                return false;
            }
            if (comp <= 0 || own.isOmega()) continue;
            covered.add(idx);
        }
        if (covered.isEmpty()) {
            return false;
        }
        Iterator iterator = covered.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.tokenList.set(index, Token.OMEGA);
        }
        return true;
    }

    public boolean hasOmega() {
        this.ensureConsistency();
        for (Token val : this.tokenList) {
            if (!val.isOmega()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        this.ensureConsistency();
        int hashCode = 0;
        for (int idx = 0; idx < this.placesList.size(); ++idx) {
            int keyCode = this.placesList.get(idx).hashCode();
            int valCode = this.tokenList.get(idx).hashCode();
            hashCode += Integer.rotateLeft(valCode, keyCode);
            hashCode += Integer.rotateLeft(keyCode, valCode);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        this.ensureConsistency();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Marking other = (Marking)obj;
        other.ensureConsistency();
        if (this.net != other.net) {
            return false;
        }
        assert (this.placesList == other.placesList);
        return Objects.equals(this.tokenList, other.tokenList);
    }

    public String toString() {
        this.ensureConsistency();
        StringBuilder strBuilder = new StringBuilder("[ ");
        for (Place place : this.net.getPlaces()) {
            strBuilder.append("[").append(place.getId()).append(":").append(this.getToken(place).toString()).append("] ");
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }
}

