/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.adt.extension.IExtensible;
import uniol.apt.util.Pair;

public class Extensible
implements IExtensible {
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();

    public boolean hasExtension(String key) {
        return this.extensions.containsKey(key);
    }

    @Override
    public void putExtension(String key, Object value, ExtensionProperty ... properties) {
        this.extensions.put(key, new Extension(value, properties));
    }

    public void putExtension(String key, Object value) {
        this.extensions.put(key, new Extension(value));
    }

    @Override
    public void removeExtension(String key) {
        this.extensions.remove(key);
    }

    @Override
    public Object getExtension(String key) {
        Extension ext = this.extensions.get(key);
        if (ext == null) {
            throw new StructureException("Extension '" + key + "' not found.");
        }
        return ext.value;
    }

    public List<Pair<String, Object>> getExtensions() {
        ArrayList<Pair<String, Object>> ret = new ArrayList<Pair<String, Object>>();
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            ret.add(new Pair<String, Object>(entry.getKey(), entry.getValue().value));
        }
        return ret;
    }

    public List<Pair<String, Object>> getExtensionsWithProperty(ExtensionProperty property) {
        ArrayList<Pair<String, Object>> ret = new ArrayList<Pair<String, Object>>();
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            Extension ext = entry.getValue();
            if (!ext.properties.contains((Object)property)) continue;
            ret.add(new Pair<String, Object>(entry.getKey(), ext.value));
        }
        return ret;
    }

    public List<Pair<String, Object>> getExtensionsWithoutProperty(ExtensionProperty property) {
        ArrayList<Pair<String, Object>> ret = new ArrayList<Pair<String, Object>>();
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            Extension ext = entry.getValue();
            if (ext.properties.contains((Object)property)) continue;
            ret.add(new Pair<String, Object>(entry.getKey(), ext.value));
        }
        return ret;
    }

    public List<Pair<String, Object>> getWriteToFileExtensions() {
        return this.getExtensionsWithProperty(ExtensionProperty.WRITE_TO_FILE);
    }

    public List<Pair<String, Object>> getCopyExtensions() {
        return this.getExtensionsWithoutProperty(ExtensionProperty.NOCOPY);
    }

    public final void copyExtensions(Extensible e) {
        for (Map.Entry<String, Extension> entry : e.extensions.entrySet()) {
            Extension ext = entry.getValue();
            if (ext.properties.contains((Object)ExtensionProperty.NOCOPY)) continue;
            this.extensions.put(entry.getKey(), ext);
        }
    }

    private static class Extension {
        final Object value;
        final Set<ExtensionProperty> properties;

        public Extension(Object value) {
            this.value = value;
            this.properties = Collections.emptySet();
        }

        public Extension(Object value, ExtensionProperty ... properties) {
            HashSet<ExtensionProperty> props = new HashSet<ExtensionProperty>(Arrays.asList(properties));
            this.value = value;
            this.properties = props.isEmpty() ? Collections.emptySet() : (props.size() == 1 ? Collections.singleton(props.iterator().next()) : Collections.unmodifiableSet(props));
        }
    }
}

