/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.automaton;

public class Symbol {
    private final String event;
    public static final Symbol EPSILON = new Symbol();

    private Symbol() {
        this.event = "";
    }

    public Symbol(String event) {
        if (event.isEmpty()) {
            throw new IllegalArgumentException("Events must be non-empty strings");
        }
        this.event = event;
    }

    public boolean isEpsilon() {
        return this.event.isEmpty();
    }

    public String getEvent() {
        return this.event;
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol other = (Symbol)o;
        return this.event.equals(other.event);
    }

    public String toString() {
        if (this.isEpsilon()) {
            return "[EPSILON]";
        }
        return "[" + this.event + "]";
    }
}

