/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.automaton;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import uniol.apt.adt.automaton.DFAState;
import uniol.apt.adt.automaton.DeterministicFiniteAutomaton;
import uniol.apt.adt.automaton.FiniteAutomaton;
import uniol.apt.adt.automaton.State;
import uniol.apt.adt.automaton.Symbol;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.EquivalenceRelation;
import uniol.apt.util.IEquivalenceRelation;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class FiniteAutomatonUtility {
    private FiniteAutomatonUtility() {
    }

    private static FiniteAutomaton getAutomaton(State state) {
        final State s = state;
        return new FiniteAutomaton(){

            @Override
            public State getInitialState() {
                return s;
            }
        };
    }

    private static DeterministicFiniteAutomaton getAutomaton(DFAState state) {
        final DFAState s = state;
        return new DeterministicFiniteAutomaton(){

            @Override
            public DFAState getInitialState() {
                return s;
            }

            @Override
            public Set<Symbol> getAlphabet() {
                return s.getDefinedSymbols();
            }
        };
    }

    public static FiniteAutomaton getEmptyLanguage() {
        return FiniteAutomatonUtility.getAutomaton(new StateWithoutArcs(false));
    }

    public static FiniteAutomaton getAtomicLanguage(Symbol atom) {
        if (atom.isEpsilon()) {
            return FiniteAutomatonUtility.getAutomaton(new EpsilonState());
        }
        final StateWithoutArcs endState = new StateWithoutArcs(true);
        final Symbol a = atom;
        return FiniteAutomatonUtility.getAutomaton(new AbstractState(false){

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return Collections.singleton(a);
            }

            @Override
            public Set<State> getFollowingStates(Symbol arg) {
                if (arg.equals(a)) {
                    return Collections.singleton(endState);
                }
                return Collections.emptySet();
            }
        });
    }

    public static FiniteAutomaton union(FiniteAutomaton a1, FiniteAutomaton a2) {
        if (a1 instanceof DeterministicFiniteAutomaton && a2 instanceof DeterministicFiniteAutomaton) {
            return FiniteAutomatonUtility.union((DeterministicFiniteAutomaton)a1, (DeterministicFiniteAutomaton)a2);
        }
        final HashSet<State> initialStates = new HashSet<State>();
        initialStates.add(a1.getInitialState());
        initialStates.add(a2.getInitialState());
        return FiniteAutomatonUtility.getAutomaton(new AbstractState(false){

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return Collections.emptySet();
            }

            @Override
            public Set<State> getFollowingStates(Symbol arg) {
                if (arg.isEpsilon()) {
                    return initialStates;
                }
                return Collections.emptySet();
            }
        });
    }

    public static DeterministicFiniteAutomaton union(DeterministicFiniteAutomaton a1, DeterministicFiniteAutomaton a2) {
        HashSet<Symbol> alphabet = new HashSet<Symbol>(a1.getAlphabet());
        alphabet.addAll(a2.getAlphabet());
        return FiniteAutomatonUtility.getAutomaton(new SynchronousParallelComposition(alphabet, a1.getInitialState(), a2.getInitialState(), SynchronousParallelComposition.Mode.UNION));
    }

    public static FiniteAutomaton intersection(FiniteAutomaton a1, FiniteAutomaton a2) {
        return FiniteAutomatonUtility.intersection(FiniteAutomatonUtility.constructDFA(a1), FiniteAutomatonUtility.constructDFA(a2));
    }

    public static DeterministicFiniteAutomaton intersection(DeterministicFiniteAutomaton a1, DeterministicFiniteAutomaton a2) {
        HashSet<Symbol> alphabet = new HashSet<Symbol>(a1.getAlphabet());
        alphabet.retainAll(a2.getAlphabet());
        return FiniteAutomatonUtility.getAutomaton(new SynchronousParallelComposition(alphabet, a1.getInitialState(), a2.getInitialState(), SynchronousParallelComposition.Mode.INTERSECTION));
    }

    public static DeterministicFiniteAutomaton negate(DeterministicFiniteAutomaton a) {
        return FiniteAutomatonUtility.negate(a, a.getAlphabet());
    }

    public static DeterministicFiniteAutomaton negate(FiniteAutomaton a, Set<Symbol> alphabet) {
        return FiniteAutomatonUtility.negate(FiniteAutomatonUtility.constructDFA(a), alphabet);
    }

    public static DeterministicFiniteAutomaton negate(DeterministicFiniteAutomaton a, Set<Symbol> alphabet) {
        if (!alphabet.containsAll(a.getAlphabet())) {
            throw new IllegalArgumentException("Alphabet of the automaton isn't subset of the given alphabet.");
        }
        return FiniteAutomatonUtility.getAutomaton(new NegationState(a.getInitialState(), new HashSet<Symbol>(alphabet)));
    }

    public static FiniteAutomaton concatenate(FiniteAutomaton a1, FiniteAutomaton a2) {
        return FiniteAutomatonUtility.getAutomaton(ConcatenateDecoratorState.getState(a1.getInitialState(), a2.getInitialState()));
    }

    public static FiniteAutomaton kleeneStar(FiniteAutomaton a) {
        return FiniteAutomatonUtility.optional(FiniteAutomatonUtility.kleenePlus(a));
    }

    public static FiniteAutomaton kleenePlus(FiniteAutomaton a) {
        return FiniteAutomatonUtility.getAutomaton(new KleeneDecoratorState(a.getInitialState(), a.getInitialState()));
    }

    public static FiniteAutomaton repeat(FiniteAutomaton a, int min, int max) {
        if (max < 0 || min < 0) {
            throw new IllegalArgumentException("min and max must not be negative");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less or equal max");
        }
        if (max == 0) {
            return FiniteAutomatonUtility.getAtomicLanguage(Symbol.EPSILON);
        }
        if (min > 0) {
            return FiniteAutomatonUtility.concatenate(a, FiniteAutomatonUtility.repeat(a, min - 1, max - 1));
        }
        return FiniteAutomatonUtility.optional(FiniteAutomatonUtility.concatenate(a, FiniteAutomatonUtility.repeat(a, 0, max - 1)));
    }

    public static FiniteAutomaton optional(FiniteAutomaton a) {
        if (a instanceof DeterministicFiniteAutomaton) {
            return FiniteAutomatonUtility.optional((DeterministicFiniteAutomaton)a);
        }
        final State initial = a.getInitialState();
        if (initial.isFinalState()) {
            return a;
        }
        return FiniteAutomatonUtility.getAutomaton(new StateWithoutArcs(true){

            @Override
            public Set<State> getFollowingStates(Symbol atom) {
                if (atom.isEpsilon()) {
                    return Collections.singleton(initial);
                }
                return Collections.emptySet();
            }
        });
    }

    public static DeterministicFiniteAutomaton optional(DeterministicFiniteAutomaton a) {
        final DFAState initial = a.getInitialState();
        if (initial.isFinalState()) {
            return a;
        }
        return FiniteAutomatonUtility.getAutomaton(new DFAState(){

            @Override
            public boolean isFinalState() {
                return true;
            }

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return initial.getDefinedSymbols();
            }

            @Override
            public DFAState getFollowingState(Symbol atom) {
                return initial.getFollowingState(atom);
            }
        });
    }

    private static Set<State> followEpsilons(Set<State> states) {
        HashSet<State> result = new HashSet<State>(states);
        LinkedList<State> unhandled = new LinkedList<State>(result);
        while (!unhandled.isEmpty()) {
            State state = (State)unhandled.removeFirst();
            for (State newState : state.getFollowingStates(Symbol.EPSILON)) {
                if (!result.add(newState)) continue;
                unhandled.add(newState);
            }
        }
        return result;
    }

    public static boolean isWordInLanguage(FiniteAutomaton a, List<String> word) {
        Set<State> states = FiniteAutomatonUtility.followEpsilons(Collections.singleton(a.getInitialState()));
        for (int position = 0; position < word.size(); ++position) {
            Symbol nextSymbol = new Symbol(word.get(position));
            HashSet<State> nextStates = new HashSet<State>();
            for (State state : states) {
                nextStates.addAll(state.getFollowingStates(nextSymbol));
            }
            states = FiniteAutomatonUtility.followEpsilons(nextStates);
        }
        for (State state : states) {
            if (!state.isFinalState()) continue;
            return true;
        }
        return false;
    }

    public static DeterministicFiniteAutomaton constructDFA(FiniteAutomaton a) {
        if (a instanceof DeterministicFiniteAutomaton) {
            return (DeterministicFiniteAutomaton)a;
        }
        return new PowerSetConstruction(a);
    }

    private static MinimalDeterministicFiniteAutomaton minimizeInternal(FiniteAutomaton a) {
        if (a instanceof MinimalDeterministicFiniteAutomaton) {
            return (MinimalDeterministicFiniteAutomaton)a;
        }
        return new MinimalDeterministicFiniteAutomaton(a);
    }

    public static DeterministicFiniteAutomaton minimize(FiniteAutomaton a) {
        return FiniteAutomatonUtility.minimizeInternal(a);
    }

    public static DeterministicFiniteAutomaton prefixClosure(FiniteAutomaton a) {
        if (a instanceof PrefixClosureAutomaton) {
            return (PrefixClosureAutomaton)a;
        }
        return new PrefixClosureAutomaton(a);
    }

    public static boolean languageEquivalent(FiniteAutomaton a1, FiniteAutomaton a2) {
        return FiniteAutomatonUtility.findWordDifference(a1, a2) == null;
    }

    public static FiniteAutomaton getDifferenceAutomaton(FiniteAutomaton a1, FiniteAutomaton a2) {
        DeterministicFiniteAutomaton dfa1 = FiniteAutomatonUtility.constructDFA(a1);
        DeterministicFiniteAutomaton dfa2 = FiniteAutomatonUtility.constructDFA(a2);
        HashSet<Symbol> alphabet = new HashSet<Symbol>(dfa1.getAlphabet());
        alphabet.addAll(dfa2.getAlphabet());
        DeterministicFiniteAutomaton notDfa1 = FiniteAutomatonUtility.negate(dfa1, alphabet);
        DeterministicFiniteAutomaton notDfa2 = FiniteAutomatonUtility.negate(dfa2, alphabet);
        return FiniteAutomatonUtility.union(FiniteAutomatonUtility.intersection(dfa1, notDfa2), FiniteAutomatonUtility.intersection(notDfa1, dfa2));
    }

    public static List<String> findWordDifference(FiniteAutomaton a1, FiniteAutomaton a2) {
        return FiniteAutomatonUtility.findAcceptedWord(FiniteAutomatonUtility.minimize(FiniteAutomatonUtility.getDifferenceAutomaton(a1, a2)));
    }

    private static List<String> findAcceptedWord(DeterministicFiniteAutomaton dfa) {
        HashSet<DFAState> statesSeen = new HashSet<DFAState>();
        LinkedList<String> word = new LinkedList<String>();
        LinkedList<Pair<DFAState, Iterator<Symbol>>> trace = new LinkedList<Pair<DFAState, Iterator<Symbol>>>();
        DFAState initial = dfa.getInitialState();
        trace.add(new Pair<DFAState, Iterator<Symbol>>(initial, initial.getDefinedSymbols().iterator()));
        while (!trace.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Pair pair = (Pair)trace.peekLast();
            if (!((Iterator)pair.getSecond()).hasNext()) {
                trace.removeLast();
                word.pollLast();
                continue;
            }
            Symbol symbol = (Symbol)((Iterator)pair.getSecond()).next();
            DFAState nextState = ((DFAState)pair.getFirst()).getFollowingState(symbol);
            if (!statesSeen.add(nextState)) continue;
            trace.add(new Pair<DFAState, Iterator<Symbol>>(nextState, nextState.getDefinedSymbols().iterator()));
            word.add(symbol.getEvent());
            if (!nextState.isFinalState()) continue;
            return word;
        }
        return null;
    }

    public static List<String> findPredicateWord(FiniteAutomaton a, Predicate<List<String>> prefixPredicate, Predicate<List<String>> wordPredicate) {
        MinimalDeterministicFiniteAutomaton dfa = FiniteAutomatonUtility.minimizeInternal(a);
        ArrayDeque<Pair<DFAState, Iterator<Symbol>>> trace = new ArrayDeque<Pair<DFAState, Iterator<Symbol>>>();
        LinkedList<String> word = new LinkedList<String>();
        DFAState initial = dfa.getInitialState();
        DFAState sinkState = FiniteAutomatonUtility.findSinkState(dfa);
        trace.add(new Pair<DFAState, Iterator<Symbol>>(initial, initial.getDefinedSymbols().iterator()));
        while (!trace.isEmpty()) {
            Pair pair = (Pair)trace.peekLast();
            if (!((Iterator)pair.getSecond()).hasNext()) {
                trace.removeLast();
                word.pollLast();
                continue;
            }
            Symbol symbol = (Symbol)((Iterator)pair.getSecond()).next();
            DFAState nextState = ((DFAState)pair.getFirst()).getFollowingState(symbol);
            if (nextState.equals(sinkState)) continue;
            word.add(symbol.getEvent());
            List roWord = ListUtils.unmodifiableList(word);
            if (prefixPredicate.evaluate(roWord)) {
                trace.addLast(new Pair<DFAState, Iterator<Symbol>>(nextState, nextState.getDefinedSymbols().iterator()));
                if (!nextState.isFinalState() || !wordPredicate.evaluate(roWord)) continue;
                return word;
            }
            word.removeLast();
        }
        return null;
    }

    private static DFAState findSinkState(MinimalDeterministicFiniteAutomaton dfa) {
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (dFAState.isFinalState()) continue;
            boolean sink = true;
            for (Symbol sym : dfa.getAlphabet()) {
                if (dFAState.getFollowingState(sym).equals(dFAState)) continue;
                sink = false;
                break;
            }
            if (!sink) continue;
            return dFAState;
        }
        return null;
    }

    public static TransitionSystem prefixLanguageLTS(FiniteAutomaton a) {
        MinimalDeterministicFiniteAutomaton dfa = FiniteAutomatonUtility.minimizeInternal(a);
        DFAState sinkState = FiniteAutomatonUtility.findSinkState(dfa);
        HashMap<DFAState, uniol.apt.adt.ts.State> stateMap = new HashMap<DFAState, uniol.apt.adt.ts.State>();
        TransitionSystem result = new TransitionSystem();
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (dFAState.equals(sinkState)) continue;
            stateMap.put(dFAState, result.createState());
        }
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (dFAState.equals(sinkState)) continue;
            uniol.apt.adt.ts.State tsState = (uniol.apt.adt.ts.State)stateMap.get(dFAState);
            for (Symbol sym : dfa.getAlphabet()) {
                DFAState next = dFAState.getFollowingState(sym);
                if (next.equals(sinkState)) continue;
                result.createArc(tsState, (uniol.apt.adt.ts.State)stateMap.get(next), sym.getEvent());
            }
        }
        if (stateMap.isEmpty()) {
            result.setInitialState(result.createState());
        } else {
            result.setInitialState((uniol.apt.adt.ts.State)stateMap.get(dfa.getInitialState()));
        }
        return result;
    }

    public static FiniteAutomaton fromPrefixLanguageLTS(TransitionSystem lts) {
        return FiniteAutomatonUtility.getAutomaton(new LTSAdaptorState(lts.getInitialState()));
    }

    public static FiniteAutomaton fromLTS(TransitionSystem lts, Collection<uniol.apt.adt.ts.State> finalStates) {
        finalStates = new HashSet<uniol.apt.adt.ts.State>(finalStates);
        return FiniteAutomatonUtility.getAutomaton(new LTSAdaptorState(lts.getInitialState(), finalStates));
    }

    public static String renderToGraphviz(FiniteAutomaton aut) {
        StringBuffer result = new StringBuffer("digraph G {\n");
        HashMap<State, String> identifier = new HashMap<State, String>();
        int id = 0;
        for (State state : FiniteAutomatonUtility.statesIterable(aut)) {
            if (state.isFinalState()) {
                result.append("  s" + id + " [peripheries=2];\n");
            }
            identifier.put(state, "s" + id++);
        }
        result.append("  start [shape=point, color=white, fontcolor=white];\n");
        result.append("  start -> " + (String)identifier.get(aut.getInitialState()) + ";\n");
        for (State state : FiniteAutomatonUtility.statesIterable(aut)) {
            String stateId = (String)identifier.get(state);
            HashSet<Symbol> symbols = new HashSet<Symbol>(state.getDefinedSymbols());
            symbols.add(Symbol.EPSILON);
            for (Symbol sym : symbols) {
                for (State next : state.getFollowingStates(sym)) {
                    String nextId = (String)identifier.get(next);
                    result.append("  " + stateId + " -> " + nextId + " [label=\"" + sym.toString() + "\"];\n");
                }
            }
        }
        result.append("}\n");
        return result.toString();
    }

    public static Iterable<State> statesIterable(FiniteAutomaton a) {
        return FiniteAutomatonUtility.statesIterable(a.getInitialState());
    }

    public static Iterable<DFAState> statesIterable(DeterministicFiniteAutomaton a) {
        return FiniteAutomatonUtility.statesIterable(a.getInitialState());
    }

    private static <S extends State> Iterable<S> statesIterable(final S initialState) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                final LinkedList<State> unhandled = new LinkedList<State>();
                final HashSet<State> seen = new HashSet<State>();
                unhandled.add(initialState);
                seen.add(initialState);
                return new Iterator<S>(){

                    @Override
                    public boolean hasNext() {
                        return !unhandled.isEmpty();
                    }

                    @Override
                    public S next() {
                        State state = (State)unhandled.pollFirst();
                        if (state == null) {
                            throw new NoSuchElementException();
                        }
                        for (State next : state.getFollowingStates(Symbol.EPSILON)) {
                            if (!seen.add(next)) continue;
                            unhandled.add(next);
                        }
                        for (Symbol symbol : state.getDefinedSymbols()) {
                            for (State next : state.getFollowingStates(symbol)) {
                                if (!seen.add(next)) continue;
                                unhandled.add(next);
                            }
                        }
                        State ret = state;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static class SynchronousParallelComposition
    extends DFAState {
        private final Set<Symbol> alphabet;
        private final DFAState state1;
        private final DFAState state2;
        private final Mode mode;

        public SynchronousParallelComposition(Set<Symbol> alphabet, DFAState state1, DFAState state2, Mode mode) {
            this.alphabet = alphabet;
            this.state1 = state1;
            this.state2 = state2;
            this.mode = mode;
        }

        @Override
        public boolean isFinalState() {
            return this.mode.isFinal(this.state1 != null && this.state1.isFinalState(), this.state2 != null && this.state2.isFinalState());
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return Collections.unmodifiableSet(this.alphabet);
        }

        @Override
        public DFAState getFollowingState(Symbol symbol) {
            if (!this.alphabet.contains(symbol)) {
                return null;
            }
            DFAState follow1 = this.state1 == null ? null : this.state1.getFollowingState(symbol);
            DFAState follow2 = this.state2 == null ? null : this.state2.getFollowingState(symbol);
            return new SynchronousParallelComposition(this.alphabet, follow1, follow2, this.mode);
        }

        public int hashCode() {
            return Objects.hashCode(this.state1) ^ Objects.hashCode(this.state2);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SynchronousParallelComposition)) {
                return false;
            }
            SynchronousParallelComposition other = (SynchronousParallelComposition)o;
            return Objects.equals(this.state1, other.state1) && Objects.equals(this.state2, other.state2);
        }

        public static enum Mode {
            UNION{

                @Override
                public boolean isFinal(boolean state1Final, boolean state2Final) {
                    return state1Final || state2Final;
                }
            }
            ,
            INTERSECTION{

                @Override
                public boolean isFinal(boolean state1Final, boolean state2Final) {
                    return state1Final && state2Final;
                }
            };


            public abstract boolean isFinal(boolean var1, boolean var2);
        }
    }

    private static class NegationState
    extends DFAState {
        private final Set<Symbol> alphabet;
        private final DFAState originalState;

        public NegationState(DFAState originalState, Set<Symbol> alphabet) {
            this.alphabet = Collections.unmodifiableSet(alphabet);
            this.originalState = originalState;
        }

        @Override
        public boolean isFinalState() {
            return this.originalState == null || !this.originalState.isFinalState();
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return this.alphabet;
        }

        @Override
        public DFAState getFollowingState(Symbol symbol) {
            if (!this.alphabet.contains(symbol)) {
                return null;
            }
            if (this.originalState == null) {
                return this;
            }
            DFAState state = this.originalState.getFollowingState(symbol);
            return new NegationState(state, this.alphabet);
        }

        public int hashCode() {
            return Objects.hashCode(this.originalState);
        }

        public boolean equals(Object o) {
            if (!(o instanceof NegationState)) {
                return false;
            }
            NegationState other = (NegationState)o;
            return Objects.equals(this.originalState, other.originalState);
        }
    }

    private static class PrefixClosureAutomaton
    implements DeterministicFiniteAutomaton {
        private final MinimalDeterministicFiniteAutomaton dfa;
        private final DFAState nonAcceptingState;

        public PrefixClosureAutomaton(FiniteAutomaton a) {
            this.dfa = FiniteAutomatonUtility.minimizeInternal(a);
            this.nonAcceptingState = FiniteAutomatonUtility.findSinkState(this.dfa);
        }

        @Override
        public DFAState getInitialState() {
            return new PrefixClosureState(this.dfa.getInitialState(), this.nonAcceptingState);
        }

        @Override
        public Set<Symbol> getAlphabet() {
            return this.dfa.getAlphabet();
        }

        private static class PrefixClosureState
        extends DFAState {
            private final DFAState originalState;
            private final DFAState nonAcceptingState;

            public PrefixClosureState(DFAState originalState, DFAState nonAcceptingState) {
                this.originalState = originalState;
                this.nonAcceptingState = nonAcceptingState;
            }

            @Override
            public boolean isFinalState() {
                return !this.originalState.equals(this.nonAcceptingState);
            }

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return this.originalState.getDefinedSymbols();
            }

            @Override
            public DFAState getFollowingState(Symbol atom) {
                DFAState followingState = this.originalState.getFollowingState(atom);
                if (followingState == null) {
                    return null;
                }
                return new PrefixClosureState(followingState, this.nonAcceptingState);
            }

            public int hashCode() {
                return this.originalState.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof PrefixClosureState)) {
                    return false;
                }
                PrefixClosureState other = (PrefixClosureState)o;
                return this.originalState.equals(other.originalState);
            }
        }
    }

    private static class MinimalDeterministicFiniteAutomaton
    implements DeterministicFiniteAutomaton {
        private final Set<Symbol> alphabet;
        private final MinimalState[] states;

        public MinimalDeterministicFiniteAutomaton(FiniteAutomaton a) {
            DeterministicFiniteAutomaton dfa = FiniteAutomatonUtility.constructDFA(a);
            this.alphabet = Collections.unmodifiableSet(dfa.getAlphabet());
            EquivalenceRelation<DFAState> partition = MinimalDeterministicFiniteAutomaton.getInitialPartitionForMinimize(dfa);
            partition = MinimalDeterministicFiniteAutomaton.refinePartition(partition, this.alphabet);
            this.states = this.constructStates(partition, dfa.getInitialState());
        }

        @Override
        public DFAState getInitialState() {
            return this.states[0];
        }

        @Override
        public Set<Symbol> getAlphabet() {
            return this.alphabet;
        }

        private static EquivalenceRelation<DFAState> getInitialPartitionForMinimize(DeterministicFiniteAutomaton a) {
            DFAState finalState = null;
            DFAState nonFinalState = null;
            EquivalenceRelation<DFAState> relation = new EquivalenceRelation<DFAState>();
            for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(a)) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                if (dFAState.isFinalState()) {
                    if (finalState == null) {
                        finalState = dFAState;
                    }
                    relation.joinClasses(finalState, dFAState);
                    continue;
                }
                if (nonFinalState == null) {
                    nonFinalState = dFAState;
                }
                relation.joinClasses(nonFinalState, dFAState);
            }
            return relation;
        }

        private static EquivalenceRelation<DFAState> refinePartition(EquivalenceRelation<DFAState> partition, Set<Symbol> alphabet) {
            EquivalenceRelation<DFAState> lastPartition;
            do {
                lastPartition = partition;
                for (final Symbol symbol : alphabet) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    final EquivalenceRelation<DFAState> current = partition;
                    IEquivalenceRelation<DFAState> predicate = new IEquivalenceRelation<DFAState>(){

                        @Override
                        public boolean isEquivalent(DFAState state1, DFAState state2) {
                            DFAState follow1 = state1.getFollowingState(symbol);
                            DFAState follow2 = state2.getFollowingState(symbol);
                            return current.isEquivalent(follow1, follow2);
                        }
                    };
                    partition = partition.refine(predicate);
                }
            } while (lastPartition != partition);
            return partition;
        }

        private MinimalState[] constructStates(EquivalenceRelation<DFAState> partition, DFAState initialState) {
            HashMap<Set<DFAState>, Integer> stateIndex = new HashMap<Set<DFAState>, Integer>();
            HashMap<Integer, Boolean> isFinalState = new HashMap<Integer, Boolean>();
            stateIndex.put(partition.getClass(initialState), 0);
            isFinalState.put(0, initialState.isFinalState());
            int nextIndex = 1;
            HashMap transitions = new HashMap();
            LinkedList<Set<DFAState>> unhandled = new LinkedList<Set<DFAState>>();
            unhandled.add(partition.getClass(initialState));
            while (!unhandled.isEmpty()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                Set state = (Set)unhandled.removeFirst();
                DFAState representingState = (DFAState)state.iterator().next();
                HashMap postset = new HashMap();
                for (Symbol symbol : this.getAlphabet()) {
                    DFAState followingState = representingState.getFollowingState(symbol);
                    Set<DFAState> next = partition.getClass(followingState);
                    if (!stateIndex.containsKey(next)) {
                        isFinalState.put(nextIndex, followingState.isFinalState());
                        stateIndex.put(next, nextIndex++);
                        unhandled.add(next);
                    }
                    postset.put(symbol, stateIndex.get(next));
                }
                transitions.put(stateIndex.get(state), postset);
            }
            int numStates = nextIndex;
            MinimalState[] result = new MinimalState[numStates];
            for (int i = 0; i < numStates; ++i) {
                result[i] = new MinimalState(this, (Map)transitions.get(i), (Boolean)isFinalState.get(i));
            }
            return result;
        }

        private static class MinimalState
        extends DFAState {
            private final MinimalDeterministicFiniteAutomaton automaton;
            private final Map<Symbol, Integer> postset;
            private final boolean isFinalState;

            public MinimalState(MinimalDeterministicFiniteAutomaton automaton, Map<Symbol, Integer> postset, boolean isFinalState) {
                this.automaton = automaton;
                this.isFinalState = isFinalState;
                this.postset = postset;
            }

            @Override
            public boolean isFinalState() {
                return this.isFinalState;
            }

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return this.automaton.getAlphabet();
            }

            @Override
            public DFAState getFollowingState(Symbol atom) {
                if (!this.automaton.getAlphabet().contains(atom)) {
                    return null;
                }
                return this.automaton.states[this.postset.get(atom)];
            }
        }
    }

    private static class PowerSetConstruction
    implements DeterministicFiniteAutomaton {
        private final Set<Symbol> alphabet;
        private final DFAState initialState;
        private final Map<Set<State>, PowerSetState> stateIdentityCache = new HashMap<Set<State>, PowerSetState>();

        private PowerSetState getState(Set<State> states) {
            PowerSetState canonical = this.stateIdentityCache.get(states);
            if (canonical != null) {
                return canonical;
            }
            PowerSetState result = new PowerSetState(states);
            canonical = this.stateIdentityCache.get(result.states);
            if (canonical != null) {
                result = canonical;
            }
            this.stateIdentityCache.put(states, result);
            this.stateIdentityCache.put(result.states, result);
            return result;
        }

        PowerSetConstruction(FiniteAutomaton a) {
            HashSet<Symbol> alph = new HashSet<Symbol>();
            for (State state : FiniteAutomatonUtility.statesIterable(a)) {
                alph.addAll(state.getDefinedSymbols());
            }
            assert (!alph.contains(Symbol.EPSILON));
            this.alphabet = Collections.unmodifiableSet(alph);
            this.initialState = this.getState(Collections.singleton(a.getInitialState()));
        }

        @Override
        public Set<Symbol> getAlphabet() {
            return this.alphabet;
        }

        @Override
        public DFAState getInitialState() {
            return this.initialState;
        }

        private class PowerSetState
        extends DFAState {
            private final Set<State> states;
            private final int hashCode;
            private final Map<Symbol, DFAState> transitions = new HashMap<Symbol, DFAState>();

            private PowerSetState(Set<State> states) {
                this.states = FiniteAutomatonUtility.followEpsilons(states);
                this.hashCode = states.hashCode();
            }

            @Override
            public Set<Symbol> getDefinedSymbols() {
                return PowerSetConstruction.this.getAlphabet();
            }

            @Override
            public boolean isFinalState() {
                for (State state : this.states) {
                    if (!state.isFinalState()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DFAState getFollowingState(Symbol atom) {
                if (!PowerSetConstruction.this.getAlphabet().contains(atom)) {
                    return null;
                }
                DFAState result = this.transitions.get(atom);
                if (result != null) {
                    return result;
                }
                HashSet<State> newStates = new HashSet<State>();
                for (State state : this.states) {
                    newStates.addAll(state.getFollowingStates(atom));
                }
                result = PowerSetConstruction.this.getState(newStates);
                this.transitions.put(atom, result);
                return result;
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object o) {
                if (!(o instanceof PowerSetState)) {
                    return false;
                }
                PowerSetState other = (PowerSetState)o;
                return this.states.equals(other.states);
            }
        }
    }

    private static class LTSAdaptorState
    implements State {
        private final Map<Symbol, Set<uniol.apt.adt.ts.State>> transitions;
        private final Collection<uniol.apt.adt.ts.State> finalStates;
        private final uniol.apt.adt.ts.State currentState;

        public LTSAdaptorState(uniol.apt.adt.ts.State state) {
            this(state, null);
        }

        public LTSAdaptorState(uniol.apt.adt.ts.State state, Collection<uniol.apt.adt.ts.State> finalStates) {
            this.finalStates = finalStates;
            this.currentState = state;
            HashMap trans = new HashMap();
            for (Arc arc : state.getPostsetEdges()) {
                Symbol symbol = new Symbol(arc.getLabel());
                HashSet states = (HashSet)trans.get(symbol);
                if (states == null) {
                    states = new HashSet();
                    trans.put(symbol, states);
                }
                states.add(arc.getTarget());
            }
            this.transitions = Collections.unmodifiableMap(trans);
        }

        @Override
        public boolean isFinalState() {
            return this.finalStates == null || this.finalStates.contains(this.currentState);
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return this.transitions.keySet();
        }

        @Override
        public Set<State> getFollowingStates(Symbol atom) {
            HashSet<State> result = new HashSet<State>();
            if (this.transitions.containsKey(atom)) {
                for (uniol.apt.adt.ts.State state : this.transitions.get(atom)) {
                    result.add(new LTSAdaptorState(state, this.finalStates));
                }
            }
            return result;
        }

        public int hashCode() {
            return this.currentState.hashCode() + Objects.hashCode(this.finalStates);
        }

        public boolean equals(Object o) {
            boolean result;
            if (!(o instanceof LTSAdaptorState)) {
                return false;
            }
            LTSAdaptorState other = (LTSAdaptorState)o;
            boolean bl = result = this.currentState.equals(other.currentState) && Objects.equals(this.finalStates, other.finalStates);
            if (result) assert (this.transitions.equals(other.transitions));
            return result;
        }
    }

    private static class KleeneDecoratorState
    extends AbstractState {
        private final State currentState;
        private final State targetState;

        public KleeneDecoratorState(State currentState, State targetState) {
            super(currentState.isFinalState());
            this.currentState = currentState;
            this.targetState = targetState;
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return this.currentState.getDefinedSymbols();
        }

        @Override
        public Set<State> getFollowingStates(Symbol atom) {
            HashSet<State> result = new HashSet<State>();
            for (State state : this.currentState.getFollowingStates(atom)) {
                result.add(new KleeneDecoratorState(state, this.targetState));
            }
            if (this.currentState.isFinalState() && atom.isEpsilon()) {
                result.add(new KleeneDecoratorState(this.targetState, this.targetState));
            }
            return result;
        }

        public int hashCode() {
            return this.currentState.hashCode() + 31 * this.targetState.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof KleeneDecoratorState)) {
                return false;
            }
            KleeneDecoratorState other = (KleeneDecoratorState)o;
            return this.currentState.equals(other.currentState) && this.targetState.equals(other.targetState);
        }
    }

    private static class ConcatenateDecoratorState
    extends AbstractState {
        private final State currentState;
        private final List<State> targetStates;

        public static ConcatenateDecoratorState getState(State currentState, State targetState) {
            if (targetState instanceof ConcatenateDecoratorState) {
                ConcatenateDecoratorState target = (ConcatenateDecoratorState)targetState;
                ArrayList<State> targets = new ArrayList<State>();
                targets.add(target.currentState);
                targets.addAll(target.targetStates);
                return ConcatenateDecoratorState.getState(currentState, targets);
            }
            return ConcatenateDecoratorState.getState(currentState, Collections.singletonList(targetState));
        }

        private static ConcatenateDecoratorState getState(State currentState, List<State> targetStates) {
            if (currentState instanceof ConcatenateDecoratorState) {
                ConcatenateDecoratorState current = (ConcatenateDecoratorState)currentState;
                ArrayList<State> targets = new ArrayList<State>();
                targets.addAll(current.targetStates);
                targets.addAll(targetStates);
                return new ConcatenateDecoratorState(current.currentState, targets);
            }
            return new ConcatenateDecoratorState(currentState, targetStates);
        }

        private ConcatenateDecoratorState(State currentState, List<State> targetStates) {
            super(false);
            assert (!targetStates.isEmpty());
            assert (ConcatenateDecoratorState.noConcatenationStates(Collections.singleton(currentState)));
            assert (ConcatenateDecoratorState.noConcatenationStates(targetStates));
            this.currentState = currentState;
            this.targetStates = targetStates;
        }

        private static boolean noConcatenationStates(Collection<State> states) {
            for (State state : states) {
                if (!(state instanceof ConcatenateDecoratorState)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return this.currentState.getDefinedSymbols();
        }

        @Override
        public Set<State> getFollowingStates(Symbol atom) {
            HashSet<State> result = new HashSet<State>();
            for (State state : this.currentState.getFollowingStates(atom)) {
                result.add(ConcatenateDecoratorState.getState(state, this.targetStates));
            }
            if (this.currentState.isFinalState() && atom.isEpsilon()) {
                if (this.targetStates.size() == 1) {
                    result.add(this.targetStates.get(0));
                } else {
                    result.add(new ConcatenateDecoratorState(this.targetStates.get(0), this.targetStates.subList(1, this.targetStates.size())));
                }
            }
            return Collections.unmodifiableSet(result);
        }

        public int hashCode() {
            return this.currentState.hashCode() + 31 * this.targetStates.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConcatenateDecoratorState)) {
                return false;
            }
            ConcatenateDecoratorState other = (ConcatenateDecoratorState)o;
            return this.currentState.equals(other.currentState) && this.targetStates.equals(other.targetStates);
        }
    }

    private static class StateWithoutArcs
    extends AbstractState {
        public StateWithoutArcs(boolean isFinalState) {
            super(isFinalState);
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return Collections.emptySet();
        }

        @Override
        public Set<State> getFollowingStates(Symbol atom) {
            return Collections.emptySet();
        }
    }

    private static abstract class AbstractState
    implements State {
        private final boolean isFinalState;

        public AbstractState(boolean isFinalState) {
            this.isFinalState = isFinalState;
        }

        @Override
        public boolean isFinalState() {
            return this.isFinalState;
        }
    }

    private static class EpsilonState
    extends DFAState {
        private EpsilonState() {
        }

        @Override
        public boolean isFinalState() {
            return true;
        }

        @Override
        public Set<Symbol> getDefinedSymbols() {
            return Collections.emptySet();
        }

        @Override
        public DFAState getFollowingState(Symbol arg) {
            return null;
        }
    }
}

