/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt.automaton;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uniol.apt.adt.automaton.DFAState;
import uniol.apt.adt.automaton.DeterministicFiniteAutomaton;
import uniol.apt.adt.automaton.FiniteAutomaton;
import uniol.apt.adt.automaton.FiniteAutomatonUtility;
import uniol.apt.adt.automaton.Symbol;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class AutomatonToRegularExpression {
    private static final RegEx EPSILON_REGEX = SymbolRegEx.EPSILON;
    private static final RegEx EMPTY_REGEX = new RegEx(){

        public String toString() {
            return "~";
        }

        @Override
        public String toStringInsideOfPrecendence(Precedence precedence) {
            return this.toString();
        }
    };

    private AutomatonToRegularExpression() {
    }

    public static String automatonToRegularExpression(FiniteAutomaton automaton) {
        DeterministicFiniteAutomaton dfa = FiniteAutomatonUtility.minimize(automaton);
        ArrayList<DFAState> states = new ArrayList<DFAState>();
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            states.add(dFAState);
        }
        String regex1 = AutomatonToRegularExpression.automatonToRegularExpression(dfa, states);
        Collections.reverse(states);
        String string = AutomatonToRegularExpression.automatonToRegularExpression(dfa, states);
        if (regex1.length() > string.length()) {
            return string;
        }
        return regex1;
    }

    private static String automatonToRegularExpression(DeterministicFiniteAutomaton dfa, Collection<DFAState> states) {
        Map<Pair<DFAState, DFAState>, RegEx> mapping = AutomatonToRegularExpression.getInitialMapping(dfa);
        for (DFAState state : states) {
            mapping = AutomatonToRegularExpression.handleNextState(dfa, mapping, state);
        }
        RegEx result = EMPTY_REGEX;
        for (DFAState state : states) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!state.isFinalState()) continue;
            Pair<DFAState, DFAState> pair = new Pair<DFAState, DFAState>(dfa.getInitialState(), state);
            result = UnionRegEx.union(result, mapping.get(pair));
        }
        return result.toString();
    }

    private static Map<Pair<DFAState, DFAState>, RegEx> getInitialMapping(DeterministicFiniteAutomaton dfa) {
        HashMap<Pair<DFAState, DFAState>, RegEx> result = new HashMap<Pair<DFAState, DFAState>, RegEx>();
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            for (DFAState dFAState2 : FiniteAutomatonUtility.statesIterable(dfa)) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                RegEx regex = dFAState.equals(dFAState2) ? EPSILON_REGEX : EMPTY_REGEX;
                result.put(new Pair<DFAState, DFAState>(dFAState, dFAState2), regex);
            }
        }
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            for (Symbol symbol : dfa.getAlphabet()) {
                Pair<DFAState, DFAState> pair = new Pair<DFAState, DFAState>(dFAState, dFAState.getFollowingState(symbol));
                RegEx regex = UnionRegEx.union((RegEx)result.get(pair), SymbolRegEx.symbol(symbol));
                result.put(pair, regex);
            }
        }
        return result;
    }

    private static Map<Pair<DFAState, DFAState>, RegEx> handleNextState(DeterministicFiniteAutomaton dfa, Map<Pair<DFAState, DFAState>, RegEx> mapping, DFAState newState) {
        HashMap<Pair<DFAState, DFAState>, RegEx> result = new HashMap<Pair<DFAState, DFAState>, RegEx>(mapping);
        for (DFAState dFAState : FiniteAutomatonUtility.statesIterable(dfa)) {
            for (DFAState dFAState2 : FiniteAutomatonUtility.statesIterable(dfa)) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                RegEx state1ToNew = mapping.get(new Pair<DFAState, DFAState>(dFAState, newState));
                RegEx newToNew = mapping.get(new Pair<DFAState, DFAState>(newState, newState));
                RegEx newToState2 = mapping.get(new Pair<DFAState, DFAState>(newState, dFAState2));
                Pair<DFAState, DFAState> pair = new Pair<DFAState, DFAState>(dFAState, dFAState2);
                RegEx state1ToState2 = mapping.get(pair);
                state1ToState2 = UnionRegEx.union(state1ToState2, ConcatenationRegEx.concatenate(state1ToNew, RepetitionRegEx.kleeneStar(newToNew), newToState2));
                result.put(pair, state1ToState2);
            }
        }
        return result;
    }

    private static class RepetitionRegEx
    implements MergingRegEx {
        private static final int UNLIMITED = -1;
        private final RegEx regex;
        private final int min;
        private final int max;

        private RepetitionRegEx(RegEx regex, int min, int max) {
            this.regex = regex;
            this.min = min;
            this.max = max;
        }

        public boolean containsEpsilon() {
            return this.min == 0;
        }

        private boolean containsSingleRepetition() {
            return this.min <= 1 && (this.max == -1 || this.max >= 1);
        }

        public String toString() {
            String str = this.regex.toStringInsideOfPrecendence(Precedence.REPETITION);
            if (this.max == -1) {
                switch (this.min) {
                    case 0: {
                        return str + "*";
                    }
                    case 1: {
                        return str + "+";
                    }
                }
                return str + "{" + this.min + ",}";
            }
            if (this.min == this.max) {
                if (str.length() * this.min <= str.length() + 3) {
                    StringBuilder result = new StringBuilder();
                    for (int i = 0; i < this.min; ++i) {
                        result.append(str);
                    }
                    return result.toString();
                }
                return str + "{" + this.min + "}";
            }
            if (this.min == 0 && this.max == 1) {
                return str + "?";
            }
            return str + "{" + this.min + "," + this.max + "}";
        }

        @Override
        public String toStringInsideOfPrecendence(Precedence precedence) {
            if (Precedence.REPETITION.compareTo(precedence) < 0) {
                return "(" + this.toString() + ")";
            }
            return this.toString();
        }

        public int hashCode() {
            return this.regex.hashCode() + this.min << 16 + this.max << 24;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepetitionRegEx)) {
                return false;
            }
            RepetitionRegEx rep = (RepetitionRegEx)o;
            return this.min == rep.min && this.max == rep.max && this.regex.equals(rep.regex);
        }

        private static RegEx simplifyForUs(RegEx other) {
            RegEx withoutEps;
            if (other instanceof UnionRegEx && !(withoutEps = ((UnionRegEx)other).unionWithoutEpsilon()).equals(other)) {
                other = new RepetitionRegEx(withoutEps, 0, 1);
            }
            return other;
        }

        @Override
        public RegEx concatenateRight(RegEx other) {
            if ((other = RepetitionRegEx.simplifyForUs(other)) instanceof RepetitionRegEx) {
                RepetitionRegEx o = (RepetitionRegEx)other;
                if (!this.regex.equals(o.regex)) {
                    return null;
                }
                if (this.max == -1 || o.max == -1) {
                    return new RepetitionRegEx(this.regex, this.min + o.min, -1);
                }
                return new RepetitionRegEx(this.regex, this.min + o.min, this.max + o.max);
            }
            if (this.regex.equals(other)) {
                if (this.max == -1) {
                    return new RepetitionRegEx(this.regex, this.min + 1, -1);
                }
                return new RepetitionRegEx(this.regex, this.min + 1, this.max + 1);
            }
            return null;
        }

        @Override
        public RegEx concatenateLeft(RegEx other) {
            return this.concatenateRight(other);
        }

        @Override
        public RegEx union(RegEx other) {
            if ((other = RepetitionRegEx.simplifyForUs(other)) instanceof RepetitionRegEx) {
                RepetitionRegEx o = (RepetitionRegEx)other;
                if (!this.regex.equals(o.regex)) {
                    return null;
                }
                if (o.min < this.min ? o.max != -1 && o.max + 1 < this.min : o.min > this.min && this.max != -1 && this.max + 1 < o.min) {
                    return null;
                }
                int newMin = Math.min(this.min, o.min);
                int newMax = Math.max(this.max, o.max);
                if (this.max == -1 || o.max == -1) {
                    newMax = -1;
                }
                return new RepetitionRegEx(this.regex, newMin, newMax);
            }
            if (this.containsSingleRepetition() && this.regex.equals(other)) {
                return this;
            }
            return null;
        }

        public static RegEx repeat(RegEx regex, int n) {
            regex = RepetitionRegEx.simplifyForUs(regex);
            if (n < 0) {
                throw new IllegalArgumentException(n + " < 0");
            }
            if (EMPTY_REGEX.equals(regex) || n == 0) {
                return EMPTY_REGEX;
            }
            if (EPSILON_REGEX.equals(regex) || n == 1) {
                return regex;
            }
            return new RepetitionRegEx(regex, n, n);
        }

        public static RegEx optional(RegEx regex) {
            regex = RepetitionRegEx.simplifyForUs(regex);
            if (EMPTY_REGEX.equals(regex) || EPSILON_REGEX.equals(regex)) {
                return EPSILON_REGEX;
            }
            if (regex instanceof RepetitionRegEx) {
                RepetitionRegEx rep = (RepetitionRegEx)regex;
                if (rep.min == 0) {
                    return regex;
                }
                if (rep.min == 1) {
                    return new RepetitionRegEx(rep.regex, 0, rep.max);
                }
            }
            return new RepetitionRegEx(regex, 0, 1);
        }

        public static RegEx kleeneStar(RegEx regex) {
            RepetitionRegEx rep;
            if ((regex = RepetitionRegEx.simplifyForUs(regex)) instanceof RepetitionRegEx && (rep = (RepetitionRegEx)regex).containsSingleRepetition()) {
                regex = rep.regex;
            }
            if (EMPTY_REGEX.equals(regex) || EPSILON_REGEX.equals(regex)) {
                return EPSILON_REGEX;
            }
            if (regex instanceof UnionRegEx) {
                regex = ((UnionRegEx)regex).unionWithoutEpsilon();
            }
            return new RepetitionRegEx(regex, 0, -1);
        }
    }

    private static class UnionRegEx
    implements RegEx {
        private final List<RegEx> regexes;

        private UnionRegEx(List<RegEx> regexes) {
            this.regexes = regexes;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            boolean first = true;
            for (RegEx regex : this.regexes) {
                if (!first) {
                    res.append('|');
                }
                res.append(regex.toStringInsideOfPrecendence(Precedence.UNION));
                first = false;
            }
            return res.toString();
        }

        @Override
        public String toStringInsideOfPrecendence(Precedence precedence) {
            if (Precedence.UNION.compareTo(precedence) < 0) {
                return "(" + this.toString() + ")";
            }
            return this.toString();
        }

        public RegEx unionWithoutEpsilon() {
            if (!this.regexes.contains(EPSILON_REGEX)) {
                return this;
            }
            ArrayList<RegEx> list = new ArrayList<RegEx>(this.regexes);
            list.remove(EPSILON_REGEX);
            return UnionRegEx.union(list);
        }

        public static RegEx union(RegEx ... regexes) {
            return UnionRegEx.union(Arrays.asList(regexes));
        }

        public static RegEx union(List<RegEx> regexes) {
            ArrayList<RegEx> list = new ArrayList<RegEx>();
            boolean hadExplicitEpsilon = false;
            boolean hadImplicitEpsilon = false;
            LinkedList<RegEx> regexesToAdd = new LinkedList<RegEx>(regexes);
            while (!regexesToAdd.isEmpty()) {
                RegEx regex = (RegEx)regexesToAdd.removeFirst();
                if (regex instanceof RepetitionRegEx) {
                    hadImplicitEpsilon |= ((RepetitionRegEx)regex).containsEpsilon();
                }
                if (EPSILON_REGEX.equals(regex)) {
                    hadExplicitEpsilon = true;
                    continue;
                }
                if (EMPTY_REGEX.equals(regex) || list.contains(regex)) continue;
                if (regex instanceof RepetitionRegEx) {
                    RepetitionRegEx rep = (RepetitionRegEx)regex;
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        RegEx item = (RegEx)it.next();
                        RegEx replacement = null;
                        if (replacement == null && item instanceof RepetitionRegEx) {
                            replacement = ((RepetitionRegEx)item).union(rep);
                        }
                        if (replacement == null) {
                            replacement = rep.union(item);
                        }
                        if (replacement == null) continue;
                        it.remove();
                        rep = null;
                        regexesToAdd.addFirst(replacement);
                        break;
                    }
                    if (rep == null) continue;
                    list.add(rep);
                    continue;
                }
                list.add(regex);
            }
            if (hadExplicitEpsilon && !hadImplicitEpsilon) {
                if (list.isEmpty()) {
                    return EPSILON_REGEX;
                }
                if (list.size() == 1) {
                    return RepetitionRegEx.optional((RegEx)list.get(0));
                }
                return RepetitionRegEx.optional(new UnionRegEx(list));
            }
            if (list.isEmpty()) {
                return EMPTY_REGEX;
            }
            if (list.size() == 1) {
                return (RegEx)list.get(0);
            }
            return new UnionRegEx(list);
        }
    }

    private static class ConcatenationRegEx
    implements RegEx {
        private final List<RegEx> regexes;

        private ConcatenationRegEx(List<RegEx> regexes) {
            this.regexes = regexes;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            for (RegEx regex : this.regexes) {
                res.append(regex.toStringInsideOfPrecendence(Precedence.CONCATENATION));
            }
            return res.toString();
        }

        @Override
        public String toStringInsideOfPrecendence(Precedence precedence) {
            if (Precedence.CONCATENATION.compareTo(precedence) < 0) {
                return "(" + this.toString() + ")";
            }
            return this.toString();
        }

        public int hashCode() {
            return this.regexes.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConcatenationRegEx)) {
                return false;
            }
            return this.regexes.equals(((ConcatenationRegEx)o).regexes);
        }

        public static RegEx concatenate(RegEx ... regexes) {
            ArrayList<RegEx> list = new ArrayList<RegEx>();
            for (RegEx regex : regexes) {
                if (regex instanceof ConcatenationRegEx) {
                    list.addAll(((ConcatenationRegEx)regex).regexes);
                    continue;
                }
                if (EMPTY_REGEX.equals(regex)) {
                    return EMPTY_REGEX;
                }
                if (EPSILON_REGEX.equals(regex)) continue;
                list.add(regex);
            }
            ListIterator<RegEx> it = list.listIterator();
            RegEx previous = null;
            while (it.hasNext()) {
                RegEx current = (RegEx)it.next();
                if (previous != null) {
                    RegEx replacement = null;
                    if (replacement == null && previous instanceof MergingRegEx) {
                        replacement = ((MergingRegEx)previous).concatenateRight(current);
                    }
                    if (replacement == null && current instanceof MergingRegEx) {
                        replacement = ((MergingRegEx)current).concatenateLeft(previous);
                    }
                    if (replacement == null && current.equals(previous)) {
                        replacement = RepetitionRegEx.repeat(current, 2);
                    }
                    if (replacement != null) {
                        it.remove();
                        RegEx tmp = (RegEx)it.previous();
                        assert (tmp == previous);
                        it.set(replacement);
                        if (it.hasPrevious()) {
                            it.previous();
                            current = (RegEx)it.next();
                        } else {
                            current = null;
                        }
                    }
                }
                previous = current;
            }
            if (list.isEmpty()) {
                return EMPTY_REGEX;
            }
            if (list.size() == 1) {
                return (RegEx)list.get(0);
            }
            return new ConcatenationRegEx(list);
        }
    }

    private static interface MergingRegEx
    extends RegEx {
        public RegEx concatenateRight(RegEx var1);

        public RegEx concatenateLeft(RegEx var1);

        public RegEx union(RegEx var1);
    }

    private static class SymbolRegEx
    implements RegEx {
        public static final SymbolRegEx EPSILON = new SymbolRegEx(Symbol.EPSILON);
        private final Symbol symbol;

        private SymbolRegEx(Symbol symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            if (this.symbol.isEpsilon()) {
                return "$";
            }
            String event = this.symbol.getEvent();
            if (event.length() == 1) {
                return event;
            }
            return "<" + event + ">";
        }

        @Override
        public String toStringInsideOfPrecendence(Precedence precedence) {
            return this.toString();
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolRegEx)) {
                return false;
            }
            return this.symbol.equals(((SymbolRegEx)o).symbol);
        }

        public static RegEx symbol(Symbol sym) {
            if (sym.isEpsilon()) {
                return EPSILON;
            }
            return new SymbolRegEx(sym);
        }
    }

    private static interface RegEx {
        public String toStringInsideOfPrecendence(Precedence var1);
    }

    private static enum Precedence {
        UNION,
        CONCATENATION,
        REPETITION;

    }
}

