/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.adt;

import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.adt.extension.Extensible;

public abstract class Node<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>>
extends Extensible
implements INode<G, E, N> {
    protected final G graph;
    protected final String id;

    protected Node(G graph, String id) {
        this.graph = graph;
        this.id = id;
    }

    protected Node(G graph, Node<G, E, N> n) {
        this(graph, n.getId());
        this.copyExtensions(n);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public G getGraph() {
        return this.graph;
    }

    @Override
    public Set<N> getPresetNodes() {
        return this.graph.getPresetNodes((String)this.id);
    }

    @Override
    public Set<N> getPostsetNodes() {
        return this.graph.getPostsetNodes((String)this.id);
    }

    @Override
    public Set<E> getPresetEdges() {
        return this.graph.getPresetEdges((String)this.id);
    }

    @Override
    public Set<E> getPostsetEdges() {
        return this.graph.getPostsetEdges((String)this.id);
    }

    public Iterable<E> getNeighboringEdges() {
        return IteratorUtils.asIterable(IteratorUtils.chainedIterator(this.getPresetEdges().iterator(), this.getPostsetEdges().iterator()));
    }

    public String toString() {
        return "Node{id=" + this.id + '}';
    }
}

