/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class CloseableCollection<T extends Closeable>
implements Closeable {
    private final List<T> objectsList = new ArrayList<T>();
    private final List<Boolean> needsCloseList = new ArrayList<Boolean>();

    CloseableCollection() {
    }

    public T get(int idx) {
        return (T)((Closeable)this.objectsList.get(idx));
    }

    public void add(T val, boolean needsClose) {
        this.objectsList.add(val);
        this.needsCloseList.add(needsClose);
    }

    @Override
    public void close() throws IOException {
        IOException err = null;
        while (!this.objectsList.isEmpty()) {
            Closeable c = (Closeable)this.objectsList.remove(0);
            boolean close = this.needsCloseList.remove(0);
            if (!close) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                err.addSuppressed(e);
            }
        }
        if (err != null) {
            throw err;
        }
    }
}

