/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeSet;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.io.FileUtils;
import uniol.apt.CloseableCollection;
import uniol.apt.module.AptModuleRegistry;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleRegistry;
import uniol.apt.module.PropertyModuleExitStatusChecker;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.module.impl.ExitStatus;
import uniol.apt.module.impl.ModuleInvoker;
import uniol.apt.module.impl.ModuleUtils;
import uniol.apt.module.impl.Parameter;
import uniol.apt.module.impl.ReturnValue;
import uniol.apt.module.impl.SimpleModulePreconditionsChecker;
import uniol.apt.ui.AptParameterTransformation;
import uniol.apt.ui.ParameterTransformation;
import uniol.apt.ui.ParametersParser;
import uniol.apt.ui.ParametersTransformer;
import uniol.apt.ui.ReturnValueTransformationWithOptions;
import uniol.apt.ui.ReturnValuesTransformer;
import uniol.apt.ui.impl.AptParametersTransformer;
import uniol.apt.ui.impl.AptReturnValuesTransformer;
import uniol.apt.ui.impl.SimpleParametersParser;
import uniol.apt.ui.impl.UIUtils;

public class APT {
    public static final String STANDARD_INPUT_SYMBOL = "-";
    public static final String GIT_VERSION;
    public static final String TIMESTAMP;
    public static final String VERSION_STRING;
    private static final ParametersParser PARAMETERS_PARSER;
    private static final ParametersTransformer PARAMETERS_TRANSFORMER;
    private static final ReturnValuesTransformer RETURN_VALUES_TRANSFORMER;
    private static final ModuleRegistry REGISTRY;
    private static final Trie<String, String> REMOVED_MODULES;
    private static final PrintStream OUT_PRINTER;
    private static final PrintStream ERR_PRINTER;

    private APT() {
    }

    private static void addRemovedModules() {
        REMOVED_MODULES.put("apt2baggins", "Use pn_convert / lts_convert apt baggins instead.");
        REMOVED_MODULES.put("apt2lola", "Use pn_convert / lts_convert apt lola instead.");
        REMOVED_MODULES.put("apt2petrify", "Use pn_convert / lts_convert apt petrify instead.");
        REMOVED_MODULES.put("apt2pnml", "Use pn_convert / lts_convert apt pnml instead.");
        REMOVED_MODULES.put("apt2synet", "Use pn_convert / lts_convert apt synet instead.");
        REMOVED_MODULES.put("petrify2apt", "Use pn_convert / lts_convert petrify apt instead.");
        REMOVED_MODULES.put("pnml2apt", "Use pn_convert / lts_convert pnml apt instead.");
        REMOVED_MODULES.put("synet2apt", "Use pn_convert / lts_convert synet apt instead.");
        REMOVED_MODULES.put("info", "Use examine_pn instead.");
        REMOVED_MODULES.put("backwards_persistent", "Use backward_persistent instead.");
    }

    public static void main(String[] args) {
        APT.addRemovedModules();
        PARAMETERS_PARSER.parse(args);
        String[] moduleNames = PARAMETERS_PARSER.getModuleNames();
        if (moduleNames.length == 0) {
            APT.printUsageAndExit();
        }
        String moduleName = moduleNames[0];
        Collection<Module> foundModules = REGISTRY.findModulesByPrefix(moduleName);
        Module module = null;
        if (foundModules.isEmpty()) {
            APT.printNoSuchModuleAndExit(moduleName);
        } else if (foundModules.size() == 1) {
            module = foundModules.iterator().next();
        } else {
            module = REGISTRY.findModule(moduleName);
            if (module == null) {
                APT.printAmbiguousModuleNameAndExit(moduleName, foundModules);
            }
        }
        List<Parameter> parameters = ModuleUtils.getParameters(module);
        List<Parameter> allParameters = ModuleUtils.getAllParameters(module);
        List<ReturnValue> returnValues = ModuleUtils.getReturnValues(module);
        List<ReturnValue> fileReturnValues = ModuleUtils.getFileReturnValues(module);
        String[] moduleArgs = PARAMETERS_PARSER.getModuleArguments(moduleName);
        try {
            if (moduleArgs.length < parameters.size()) {
                APT.printTooFewArgumentsAndExit(module);
            }
            if (moduleArgs.length > allParameters.size() + fileReturnValues.size()) {
                APT.printTooManyArgumentsAndExit(module);
            }
            int numberOfUsedParameters = moduleArgs.length > allParameters.size() ? allParameters.size() : moduleArgs.length;
            APT.checkNoTwoStdinParameters(moduleArgs, numberOfUsedParameters, allParameters);
            Object[] transformedArgs = new Object[numberOfUsedParameters];
            for (int i = 0; i < numberOfUsedParameters; ++i) {
                transformedArgs[i] = PARAMETERS_TRANSFORMER.transform(moduleArgs[i], allParameters.get(i).getKlass());
            }
            SimpleModulePreconditionsChecker checker = new SimpleModulePreconditionsChecker();
            List<Parameter> unmetParameters = checker.check(REGISTRY, module, transformedArgs);
            if (!unmetParameters.isEmpty()) {
                APT.printPreconditionsUnmetAndExit(unmetParameters);
            }
            ModuleInvoker invoker = new ModuleInvoker();
            List<Object> values = invoker.invoke(module, transformedArgs);
            String[] fileArgs = Arrays.copyOfRange(moduleArgs, numberOfUsedParameters, moduleArgs.length);
            APT.printModuleOutput(fileArgs, returnValues, values);
            PropertyModuleExitStatusChecker statusChecker = new PropertyModuleExitStatusChecker();
            ExitStatus status = statusChecker.check(module, values);
            OUT_PRINTER.flush();
            System.exit(status.getValue());
        }
        catch (ModuleException e) {
            ERR_PRINTER.println(String.format("Error while invoking module '%s':%n  %s", module.getName(), e.getMessage()));
            ERR_PRINTER.flush();
            System.exit(ExitStatus.ERROR.getValue());
        }
    }

    private static void checkNoTwoStdinParameters(String[] moduleArgs, int numberOfUsedParameters, List<Parameter> allParameters) {
        boolean hasStdInParameter = false;
        for (int i = 0; i < numberOfUsedParameters; ++i) {
            if (!moduleArgs[i].equals(STANDARD_INPUT_SYMBOL) || !APT.isFileSourceParameter(allParameters.get(i))) continue;
            if (hasStdInParameter) {
                APT.printCanOnlyReadOneParameterFromStdInAndExit();
            }
            hasStdInParameter = true;
        }
    }

    private static boolean isFileSourceParameter(Parameter parameter) {
        Class<?> klass = parameter.getKlass();
        ParameterTransformation<?> transformation = PARAMETERS_TRANSFORMER.getTransformation(klass);
        if (transformation == null) {
            return false;
        }
        AptParameterTransformation annotation = transformation.getClass().getAnnotation(AptParameterTransformation.class);
        if (annotation == null) {
            return false;
        }
        return annotation.fileSource();
    }

    private static void printModuleOutput(String[] fileArgs, List<ReturnValue> returnValues, List<Object> values) throws ModuleException {
        boolean hasStandardOutputFileReturnValue = false;
        for (int i = 0; i < fileArgs.length; ++i) {
            if (!fileArgs[i].equals(STANDARD_INPUT_SYMBOL)) continue;
            hasStandardOutputFileReturnValue = true;
        }
        try (CloseableCollection<PrintStream> outputs = new CloseableCollection<PrintStream>();){
            int i;
            boolean[] outputWithName = new boolean[values.size()];
            String[] extraOptions = new String[values.size()];
            int usedFileArgsCount = 0;
            for (i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) {
                    outputWithName[i] = false;
                    outputs.add(null, false);
                    continue;
                }
                String returnValueName = returnValues.get(i).getName();
                boolean isRawReturnValue = returnValues.get(i).hasProperty("raw");
                boolean isFileReturnValue = returnValues.get(i).hasProperty("file");
                if (isFileReturnValue && fileArgs.length > usedFileArgsCount) {
                    String[] parts;
                    String filename = fileArgs[usedFileArgsCount];
                    Class<?> klass = returnValues.get(i).getKlass();
                    if (RETURN_VALUES_TRANSFORMER.getTransformation(klass) instanceof ReturnValueTransformationWithOptions && (parts = filename.split(":", 2)).length == 2) {
                        extraOptions[i] = parts[0];
                        filename = parts[1];
                    }
                    if (filename.equals(STANDARD_INPUT_SYMBOL)) {
                        outputs.add(OUT_PRINTER, false);
                    } else {
                        outputs.add(APT.openOutput(filename), true);
                    }
                    outputWithName[i] = false;
                    ++usedFileArgsCount;
                    continue;
                }
                if (hasStandardOutputFileReturnValue) {
                    outputWithName[i] = false;
                    outputs.add(null, false);
                    continue;
                }
                outputs.add(OUT_PRINTER, false);
                outputWithName[i] = !isRawReturnValue;
            }
            for (i = 0; i < values.size(); ++i) {
                PrintStream out = (PrintStream)outputs.get(i);
                if (out == null) continue;
                if (outputWithName[i]) {
                    out.print(returnValues.get(i).getName() + ": ");
                }
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                if (extraOptions[i] == null) {
                    RETURN_VALUES_TRANSFORMER.transform(writer, values.get(i), returnValues.get(i).getKlass());
                } else {
                    RETURN_VALUES_TRANSFORMER.transform(writer, values.get(i), returnValues.get(i).getKlass(), extraOptions[i]);
                }
                writer.flush();
                out.println();
            }
        }
        catch (IOException e) {
            ERR_PRINTER.println("Error writing to file: " + e.getMessage());
            ERR_PRINTER.flush();
            System.exit(ExitStatus.ERROR.getValue());
        }
    }

    private static void printPreconditionsUnmetAndExit(List<Parameter> unmetParameters) {
        ERR_PRINTER.println("Some preconditions are unmet:");
        for (Parameter parameter : unmetParameters) {
            ERR_PRINTER.print("Parameter \"" + parameter.getName() + "\" is not");
            for (String property : parameter.getProperties()) {
                ERR_PRINTER.print(" " + property);
            }
            ERR_PRINTER.println();
        }
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static PrintStream openOutput(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            throw new IOException("File '" + file + "' already exists");
        }
        return new PrintStream((OutputStream)FileUtils.openOutputStream(file), false, "UTF-8");
    }

    private static void printVersion() {
        OUT_PRINTER.println(VERSION_STRING + ".");
        OUT_PRINTER.println();
    }

    private static void printTooManyArgumentsAndExit(Module module) throws ModuleException {
        ERR_PRINTER.println("Too many arguments");
        ERR_PRINTER.println();
        ERR_PRINTER.println(UIUtils.getModuleUsage(module, PARAMETERS_TRANSFORMER));
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printTooFewArgumentsAndExit(Module module) throws ModuleException {
        ERR_PRINTER.println("Too few arguments");
        ERR_PRINTER.println();
        ERR_PRINTER.println(UIUtils.getModuleUsage(module, PARAMETERS_TRANSFORMER));
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printAmbiguousModuleNameAndExit(String moduleName, Collection<Module> foundModules) {
        ERR_PRINTER.println("Ambiguous module name: " + moduleName);
        ERR_PRINTER.println();
        ERR_PRINTER.println("Available modules (starting with " + moduleName + "):");
        APT.printModuleList(foundModules, ERR_PRINTER);
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printNoSuchModuleAndExit(String moduleName) {
        ERR_PRINTER.println("No such module: " + moduleName);
        SortedMap<String, String> messages = REMOVED_MODULES.prefixMap(moduleName);
        if (messages.size() == 1) {
            Map.Entry entry = messages.entrySet().iterator().next();
            ERR_PRINTER.println(String.format("The module '%s' was removed. %s", entry.getKey(), entry.getValue()));
        }
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printUsageAndExit() {
        APT.printVersion();
        OUT_PRINTER.println("Usage: apt <module> <arguments>");
        OUT_PRINTER.println();
        OUT_PRINTER.println("Available modules:");
        APT.printModuleList(REGISTRY.getModules(), OUT_PRINTER);
        OUT_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printCanOnlyReadOneParameterFromStdInAndExit() {
        ERR_PRINTER.println("Only one parameter can be read from standard input at the same time");
        ERR_PRINTER.flush();
        System.exit(ExitStatus.ERROR.getValue());
    }

    private static void printModuleList(Collection<Module> modules, PrintStream printer) {
        for (Category category : Category.values()) {
            List<Module> modulesByCategory = ModuleUtils.getModulesByCategory(modules, category);
            if (modulesByCategory.isEmpty()) continue;
            printer.println();
            printer.println(category.getName());
            for (int i = 0; i < category.getName().length(); ++i) {
                printer.print("=");
            }
            printer.println();
            TreeSet<Module> sortedModules = new TreeSet<Module>(new Comparator<Module>(){

                @Override
                public int compare(Module o1, Module o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            sortedModules.addAll(modulesByCategory);
            int longestModuleName = 0;
            for (Module module : modules) {
                longestModuleName = Math.max(longestModuleName, module.getName().length());
            }
            String format = "  %-" + Integer.toString(longestModuleName) + "s  %s";
            for (Module module : sortedModules) {
                printer.println(String.format(format, module.getName(), module.getShortDescription()));
            }
        }
    }

    static {
        Properties props = new Properties();
        try (InputStream in = APT.class.getResourceAsStream("APT.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException e) {
            props = new Properties();
        }
        GIT_VERSION = props.getProperty("git-version", "UNKNOWN");
        TIMESTAMP = props.getProperty("timestamp", "UNKNOWN");
        VERSION_STRING = "APT version " + GIT_VERSION + " built on " + TIMESTAMP;
        PARAMETERS_PARSER = new SimpleParametersParser();
        PARAMETERS_TRANSFORMER = AptParametersTransformer.INSTANCE;
        RETURN_VALUES_TRANSFORMER = AptReturnValuesTransformer.INSTANCE;
        REGISTRY = AptModuleRegistry.INSTANCE;
        REMOVED_MODULES = new PatriciaTrie<String>();
        OUT_PRINTER = System.out;
        ERR_PRINTER = System.err;
    }
}

