/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Binary
extends EncodingStrategyAdapter {
    public IConstr addAtMostOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        int n;
        int n2;
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n3 = iVecInt.size();
        int n4 = (int)Math.ceil(Math.log(n3) / Math.log(2.0));
        int n5 = (int)Math.pow(2.0, n4) - n3;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = iSolver.nextFreeVarId(true);
        }
        VecInt vecInt = new VecInt();
        String string = "";
        for (n2 = 0; n2 < n5; ++n2) {
            string = Integer.toBinaryString(n2);
            while (string.length() != n4 - 1) {
                string = "0" + string;
            }
            for (n = 0; n < n4 - 1; ++n) {
                vecInt.push(-iVecInt.get(n2));
                if (string.charAt(n) == '0') {
                    vecInt.push(-nArray[n]);
                } else {
                    vecInt.push(nArray[n]);
                }
                constrGroup.add(iSolver.addClause(vecInt));
                vecInt.clear();
            }
        }
        for (n2 = n5; n2 < n3; ++n2) {
            string = Integer.toBinaryString(2 * n5 + n2 - n5);
            while (string.length() != n4) {
                string = "0" + string;
            }
            for (n = 0; n < n4; ++n) {
                vecInt.push(-iVecInt.get(n2));
                if (string.charAt(n) == '0') {
                    vecInt.push(-nArray[n]);
                } else {
                    vecInt.push(nArray[n]);
                }
                constrGroup.add(iSolver.addClause(vecInt));
                vecInt.clear();
            }
        }
        return constrGroup;
    }

    public IConstr addAtMost(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        int n2;
        int n3;
        int n4 = iVecInt.size();
        int n5 = (int)Math.ceil(Math.log(n4) / Math.log(2.0));
        ConstrGroup constrGroup = new ConstrGroup(false);
        int[][] nArray = new int[n][n5];
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                nArray[i][n3] = iSolver.nextFreeVarId(true);
            }
        }
        int[][] nArray2 = new int[n][n4];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                nArray2[n3][n2] = iSolver.nextFreeVarId(true);
            }
        }
        VecInt vecInt = new VecInt();
        VecInt vecInt2 = new VecInt();
        String string = "";
        for (int i = 0; i < n4; ++i) {
            n3 = Math.max(1, n - n4 + i + 1);
            n2 = Math.min(i + 1, n);
            vecInt.push(-iVecInt.get(i));
            string = Integer.toBinaryString(i);
            while (string.length() != n5) {
                string = "0" + string;
            }
            for (int j = n3 - 1; j < n2; ++j) {
                vecInt.push(nArray2[j][i]);
                for (int k = 0; k < n5; ++k) {
                    vecInt2.push(-nArray2[j][i]);
                    if (string.charAt(k) == '0') {
                        vecInt2.push(-nArray[j][k]);
                    } else {
                        vecInt2.push(nArray[j][k]);
                    }
                    constrGroup.add(iSolver.addClause(vecInt2));
                    vecInt2.clear();
                }
            }
            constrGroup.add(iSolver.addClause(vecInt));
            vecInt.clear();
        }
        return constrGroup;
    }

    public IConstr addAtLeast(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        VecInt vecInt = new VecInt();
        for (int i = 0; i < iVecInt.size(); ++i) {
            vecInt.push(-iVecInt.get(i));
        }
        return this.addAtMost(iSolver, vecInt, iVecInt.size() - n);
    }

    public IConstr addExactlyOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        constrGroup.add(this.addAtLeastOne(iSolver, iVecInt));
        constrGroup.add(this.addAtMostOne(iSolver, iVecInt));
        return constrGroup;
    }

    public IConstr addExactly(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        constrGroup.add(this.addAtLeast(iSolver, iVecInt, n));
        constrGroup.add(this.addAtMost(iSolver, iVecInt, n));
        return constrGroup;
    }
}

