/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final IVisualizationTool visuTool;
    private final IVisualizationTool cleanVisuTool;
    private final IVisualizationTool restartVisuTool;
    private long begin;
    private long end;
    private int counter;
    private long index;
    private int nVar;
    private double maxY;

    public SpeedTracing(IVisualizationTool iVisualizationTool, IVisualizationTool iVisualizationTool2, IVisualizationTool iVisualizationTool3) {
        this.visuTool = iVisualizationTool;
        this.cleanVisuTool = iVisualizationTool2;
        this.restartVisuTool = iVisualizationTool3;
        iVisualizationTool.init();
        iVisualizationTool2.init();
        iVisualizationTool3.init();
        this.begin = System.currentTimeMillis();
        this.counter = 0;
        this.index = 0L;
        this.maxY = 0.0;
    }

    @Override
    public void propagating(int n, IConstr iConstr) {
        this.end = System.currentTimeMillis();
        if (this.end - this.begin >= 2000L) {
            long l = this.end - this.begin;
            this.index += l;
            double d = (long)this.counter / l * 1000L;
            if (d > this.maxY) {
                this.maxY = d;
            }
            this.visuTool.addPoint((double)this.index / 1000.0, d);
            this.cleanVisuTool.addPoint((double)this.index / 1000.0, 0.0);
            this.restartVisuTool.addPoint((double)this.index / 1000.0, 0.0);
            this.begin = System.currentTimeMillis();
            this.counter = 0;
        }
        ++this.counter;
    }

    @Override
    public void end(Lbool lbool) {
        this.visuTool.end();
        this.cleanVisuTool.end();
        this.restartVisuTool.end();
    }

    @Override
    public void cleaning() {
        this.end = System.currentTimeMillis();
        long l = this.index + this.end - this.begin;
        this.visuTool.addPoint((double)l / 1000.0, (long)this.counter / (this.end - this.begin) * 1000L);
        this.cleanVisuTool.addPoint((double)l / 1000.0, this.maxY);
        this.restartVisuTool.addInvisiblePoint(l, 0.0);
    }

    @Override
    public void restarting() {
        this.end = System.currentTimeMillis();
        long l = this.index + this.end - this.begin;
        double d = (long)this.counter / (this.end - this.begin) * 1000L;
        this.visuTool.addPoint((double)l / 1000.0, d);
        if (d > this.maxY) {
            this.maxY = d;
        }
        this.restartVisuTool.addPoint((double)l / 1000.0, this.maxY);
        this.cleanVisuTool.addInvisiblePoint(l, 0.0);
    }

    @Override
    public void start() {
        this.visuTool.init();
        this.cleanVisuTool.init();
        this.restartVisuTool.init();
        this.begin = System.currentTimeMillis();
        this.counter = 0;
        this.index = 0L;
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
    }
}

