/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictDepthTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private int counter;
    private int nVar;
    private final IVisualizationTool conflictDepthVisu;
    private final IVisualizationTool conflictDepthRestartVisu;
    private final IVisualizationTool conflictDepthCleanVisu;

    public ConflictDepthTracing(IVisualizationTool iVisualizationTool, IVisualizationTool iVisualizationTool2, IVisualizationTool iVisualizationTool3) {
        this.conflictDepthVisu = iVisualizationTool;
        this.conflictDepthRestartVisu = iVisualizationTool2;
        this.conflictDepthCleanVisu = iVisualizationTool3;
        this.counter = 0;
    }

    @Override
    public void conflictFound(IConstr iConstr, int n, int n2) {
        this.conflictDepthVisu.addPoint(this.counter, n2);
        this.conflictDepthRestartVisu.addInvisiblePoint(this.counter, n2);
        this.conflictDepthCleanVisu.addInvisiblePoint(this.counter, n2);
        ++this.counter;
    }

    @Override
    public void end(Lbool lbool) {
        this.conflictDepthVisu.end();
        this.conflictDepthRestartVisu.end();
        this.conflictDepthCleanVisu.end();
    }

    @Override
    public void start() {
        this.conflictDepthVisu.init();
        this.conflictDepthRestartVisu.init();
        this.conflictDepthCleanVisu.init();
        this.counter = 0;
    }

    @Override
    public void restarting() {
        this.conflictDepthRestartVisu.addPoint(this.counter, this.nVar);
        this.conflictDepthCleanVisu.addPoint(this.counter, 0.0);
        this.conflictDepthVisu.addInvisiblePoint(this.counter, this.nVar);
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
    }

    @Override
    public void cleaning() {
        this.conflictDepthRestartVisu.addPoint(this.counter, 0.0);
        this.conflictDepthCleanVisu.addPoint(this.counter, this.nVar);
        this.conflictDepthVisu.addInvisiblePoint(this.counter, this.nVar);
    }
}

