/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.xplain.HighLevelXplain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedCNFReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    private int numberOfComponents;
    private final HighLevelXplain<ISolver> hlxplain;
    private int currentComponentIndex;

    public GroupedCNFReader(HighLevelXplain<ISolver> highLevelXplain) {
        super(highLevelXplain, "gcnf");
        this.hlxplain = highLevelXplain;
    }

    @Override
    protected void readProblemLine() throws IOException, ParseFormatException {
        String string = this.scanner.nextLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p " + this.formatString + " ...> expected");
        }
        String[] stringArray = (string = string.trim()).split("\\s+");
        if (stringArray.length < 5 || !"p".equals(stringArray[0]) || !this.formatString.equals(stringArray[1])) {
            throw new ParseFormatException("problem line expected (p " + this.formatString + " ...)");
        }
        int n = Integer.parseInt(stringArray[2]);
        assert (n > 0);
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringArray[3]);
        assert (this.expectedNbOfConstr > 0);
        this.numberOfComponents = Integer.parseInt(stringArray[4]);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    @Override
    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        boolean bl = false;
        String string = this.scanner.next();
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new ParseFormatException("Component index required at the beginning of the clause");
        }
        this.currentComponentIndex = Integer.valueOf(string.substring(1, string.length() - 1));
        if (this.currentComponentIndex < 0 || this.currentComponentIndex > this.numberOfComponents) {
            throw new ParseFormatException("wrong component index: " + this.currentComponentIndex);
        }
        while (!this.scanner.eof()) {
            int n = this.scanner.nextInt();
            if (n == 0) {
                if (this.literals.size() <= 0) break;
                this.flushConstraint();
                this.literals.clear();
                bl = true;
                break;
            }
            this.literals.push(n);
        }
        return bl;
    }

    @Override
    protected void flushConstraint() throws ContradictionException {
        block4: {
            try {
                if (this.currentComponentIndex == 0) {
                    this.hlxplain.addClause(this.literals);
                } else {
                    this.hlxplain.addClause(this.literals, this.currentComponentIndex);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.isVerbose()) break block4;
                System.err.println("c Skipping constraint " + this.literals);
            }
        }
    }
}

