/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public final class MiniSATRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private double nofConflicts;
    private SearchParams params;
    private int conflictcount;

    public void init(SearchParams searchParams) {
        this.params = searchParams;
        this.nofConflicts = searchParams.getInitConflictBound();
    }

    public long nextRestartNumberOfConflict() {
        return Math.round(this.nofConflicts);
    }

    public void onRestart() {
        this.nofConflicts *= this.params.getConflictBoundIncFactor();
    }

    public String toString() {
        return "MiniSAT restarts strategy";
    }

    public boolean shouldRestart() {
        return (double)this.conflictcount >= this.nofConflicts;
    }

    public void onBackjumpToRootLevel() {
        this.conflictcount = 0;
    }

    public void reset() {
        this.conflictcount = 0;
    }

    public void newConflict() {
        ++this.conflictcount;
    }

    public SearchParams getSearchParams() {
        return this.params;
    }

    public void newLearnedClause(Constr constr, int n) {
    }
}

